(function() {

	var registry = {};

	var register = function(id, properties) {
		registry[id] = properties;
	}

	var store = function(id, key, value) {
		registry[id][key] = value;
	}

	var get = function(id, key) {
		return registry[id][key];
	}

	var retrieve = function(key) {
		var result = {};
		for(id in registry) {
			result[id] = registry[id][key];
		}
		return result;
	}

	charts = {
		register: register,
		store: store,
		get: get,
		retrieve: retrieve
	};

})();
