// the id of the system being displayed
var system;

// the name of the faction which owns the system
var faction;

// the data for the worlds
var orbitals;

// the data for the zones
var zoneData = new Array();

// Temporary start up function to select system
$(function() {
	// set all circles inactive, clear inner html and title attribute
	$(".circle").attr('class', "circle inactive").html("").attr('title', "");
	
	// load system from GET data (POST does not work for js)
	var getParameters = new Array();
	
	var query = window.location.search.substring(1);
	query = decodeURI(query);
	
	var params = query.split('&');
	for (var entry in params) {
		var pos = params[entry].indexOf('=');
		if (pos > 0) {
			var key = params[entry].substring(0,pos);
			var val = params[entry].substring(pos+1);
			getParameters[key] = val;
		}
	}
	var world = getParameters['world'];


	if(!world) {
		$('#planetTitle').html("No world selected");
	} else {
		$('#planetTitle').html("Loading world...");
		$('#waitingicon').html('<div style="height:20px;"><img style="margin-top:32px;margin-left:auto;margin-right:auto;display:block;" src="/images/pod.loading.gif" /></div>');
	}	

	$.getJSON('/api/data/entity/' + world).then(function(data) {
		system = data.System[0];

		var count = 4;
		var worlds = new Array();
		var zonesTemp = new Array();
		function meh(data) {
			for(var k in data) {
				if(data.hasOwnProperty(k)) {
					data[k]['id'] = k;
					worlds[k] = data[k];
					worlds.push(data[k]);
				}
			}
			count--;
			if(count == 0) more_work();
		}

		function meh2(data) {
			for(var k in data) {
				if(data.hasOwnProperty(k)) {
					zonesTemp.push(data[k]);
				}
			}
			count--;
			if(count == 0) more_work();
		}

		
		$.getJSON('/api/data/entities/star', { "System" : system }).then(meh);
		$.getJSON('/api/data/entities/planet', { "System" : system }).then(meh);
		$.getJSON('/api/data/entities/moon', { "System" : system }).then(meh);
		$.getJSON('/api/data/entities/zone', { "System" : system }).then(meh2);

		function more_work(){
			worlds.sort(function(a, b) {
				var one = a["Orbit Index"];
				if(typeof one === "undefined") {
					one = "";
				} else {
					one = one[0];
				}
				var other = b["Orbit Index"];
				if(typeof other === "undefined") {
					other = "";
				} else {
					other = other[0];
				}
				return one.localeCompare(other);					
			});

			if(worlds.length <= 0) {
				$('#leftmenuheader').html("<h3>Invalid System</h3>");
				$('#leftmenucontent').html('');
				$('#planetTitle').html("Invalid system");
				$('#waitingicon').html('');
				return;
			}
			orbitals = new Array();

			// run through first world
			for(var i = 0; i < worlds.length; i++) {
				worldIndex = worlds[i]["id"];
		
				system = worlds[worldIndex]['System'][0];
				// make world array
				orbitals[worldIndex] = new Array();

				// set up data container for total production
				orbitals[worldIndex]['total production'] = new Array();

				// save variables for world
				orbitals[worldIndex]['name'] = worldIndex;
				orbitals[worldIndex]['image'] = worlds[worldIndex]['Image'][0].toLowerCase();
				orbitals[worldIndex]['world type'] = worlds[worldIndex]['Type'][0].toLowerCase();
				orbitals[worldIndex]['zones'] = 0;
				if(worlds[worldIndex]['Zones']) {
					orbitals[worldIndex]['zones'] = Number(worlds[worldIndex]['Zones'][0]);
				}
				orbitals[worldIndex]['title'] = worlds[worldIndex]['entry title'][0];
				orbitals[worldIndex]['index'] = 0;
				if(worlds[worldIndex]['Orbit Index']) {
					orbitals[worldIndex]['index'] = worlds[worldIndex]['Orbit Index'][0];
				}
	
				var classArray = worlds[worldIndex]['is a'];
				if(classArray && $.inArray('star', classArray) >= 0) {
					entry['class'] = "star";
				} else {
					entry['class'] = classArray[0];
				}		
	
				if(worlds[worldIndex]['Outer Attack']) {
					orbitals[worldIndex]['outer-offence'] = worlds[worldIndex]['Outer Attack'][0];
				}
				if(worlds[worldIndex]['Middle Attack']) {
					orbitals[worldIndex]['middle-offence'] = worlds[worldIndex]['Middle Attack'][0];
				}
				if(worlds[worldIndex]['Inner Attack']) {
					orbitals[worldIndex]['inner-offence'] = worlds[worldIndex]['Inner Attack'][0];
				}
				if(worlds[worldIndex]['Outer Defence']) {
					orbitals[worldIndex]['outer-defence'] = worlds[worldIndex]['Outer Defence'][0];
				}
				if(worlds[worldIndex]['Middle Defence']) {
					orbitals[worldIndex]['middle-defence'] = worlds[worldIndex]['Middle Defence'][0];
				}
				if(worlds[worldIndex]['Inner Defence']) {
					orbitals[worldIndex]['inner-defence'] = worlds[worldIndex]['Inner Defence'][0];
				}
	
				if(worlds[worldIndex]['Effectiveness Levels']) {
					orbitals[worldIndex]['effectiveness'] = worlds[worldIndex]['Effectiveness Levels'][0];
				}				

				faction = worlds[worldIndex]['Faction'][0];
			}

			var zones = new Array();

			// run through all zones
			for(var zoneIndex in zonesTemp) { 
				zones.push(zonesTemp[zoneIndex]);
			}
			
			zones.sort(function(a,b) {
				var aName = a['On'][0];
				var bName = b['On'][0];

				var val = alphanumCase(aName, bName);

				if(val == 0) {
					var aZone = a['entry title'][0];
					var bZone = b['entry title'][0];
					val = alphanumCase(aZone, bZone);
				}
				return val;
			});
			// data array to fill from query data - this array is used to sort the zones from their normal order (1, 10, 11 ... 19, 2, 20) to a proper order, as well as to clean up some values
		
			// zone ID
			var zoneNumbers = new Array();

			// run through all zones
			for(var zoneIndex in zones) { 
			
				var worldOfZone = zones[zoneIndex]['On'][0];

				

				var zoneNumber = zoneNumbers[worldOfZone];

				if(!zoneNumber) {
					zoneNumbers[worldOfZone] = 1;
					zoneNumber = 1;
				}

				// initialize array for data in zoneData

				if(!zoneData[worldOfZone]) {
					zoneData[worldOfZone] = new Array();
				}

				zoneData[worldOfZone][zoneNumber] = new Array();

				zoneData[worldOfZone][zoneNumber]['entry title'] = zones[zoneIndex]['entry title'][0];


				zoneData[worldOfZone][zoneNumber]['Planet'] = orbitals[worldOfZone]['title'];
				zoneData[worldOfZone][zoneNumber]['PlanetRef'] = worldOfZone;
				zoneData[worldOfZone][zoneNumber]['Description'] = "";
				if(zones[zoneIndex]['Description']) {
					zoneData[worldOfZone][zoneNumber]['Description'] = zones[zoneIndex]['Description'][0];
				}

				// extract zone type or read as unclaimed if there is no zone type
				if(zones[zoneIndex]['Type']) {
					zoneData[worldOfZone][zoneNumber]['Type'] = zones[zoneIndex]['Type'][0];
				} else {
					zoneData[worldOfZone][zoneNumber]['Type'] = "unclaimed";
				}

				// fill production or set to Empty if zone does not produce
				if(zones[zoneIndex]['Production']) {
					// cue vloeken van Brend - nodig om inconsistent spatiegebruik te repareren
					var tempz = zones[zoneIndex]['Production'][0].replace("0(:", "0 (:").replace("1(:", "1 (:").replace("2(:", "2 (:").replace("3(:", "3 (:").replace("4(:", "4 (:").replace("5(:", "5 (:").replace("6(:", "6 (:").replace("7(:", "7 (:").replace("8(:", "8 (:").replace("9(:", "9 (:").replace("0(:", "0 (:");
					zoneData[worldOfZone][zoneNumber]['Production'] = tempz;

					// filter tertiary zones 
					if(!tempz.indexOf("+") == 0) {
						// increment total production
						var tot_prod = tempz.split(" (:");
						var tot = Number(tot_prod[0]);
						var prod = tot_prod[1].split(")")[0];

						// remove shorthand options from list

						switch(prod) {
							case "gas":
								prod = "gasses";
								break;
							case "rares":
								prod = "rare-elements";
								break;
							case "conmats":
								prod = "construction-materials";
								break;
							case "congoods":
								prod = "consumer-goods";
								break;
							case "emds":
								prod = "exotic-matter-devices";
								break;
							case "healthcare":
								prod = "healthcare-products";
								break;
							case "ict":
								prod = "ict-technology";
								break;
							case "om-trade":
								prod = "open-market-trade";
								break;
							case "mtcf":
								prod = "mass-transit-cargo-freighters";
								break;
							case "freighters":
								prod = "mass-transit-cargo-freighters";
								break;
							case "terraform":
								prod = "terraformation-modules";
								break;
						}

						if(!orbitals[worldOfZone]['total production'][prod]) {
							orbitals[worldOfZone]['total production'][prod] = 0;
						}

						orbitals[worldOfZone]['total production'][prod] += tot;

					}
				} else {
					zoneData[worldOfZone][zoneNumber]['Production'] = "Empty";
				} 
			
				// Fleet zones don't produce, but aren't empty
				if(zoneData[worldOfZone][zoneNumber]['Type'] == "rules:fleet_zone") {
					zoneData[worldOfZone][zoneNumber]['Production'] = "Fleet";
					zoneData[worldOfZone][zoneNumber]['Breakdown'] = "Fleet Support Zone"
				} 
			
				// Planetary Defence Zones don't produce but aren't empty
				if(zoneData[worldOfZone][zoneNumber]['Type'] == "rules:planetary_defence_zone") {
					zoneData[worldOfZone][zoneNumber]['Production'] = "+6 :dot1:";
					zoneData[worldOfZone][zoneNumber]['Breakdown'] = "Planetary Defence Zone";
				
				}
			
				// Geneaological Archives don't produce but aren't empty
				if(zoneData[worldOfZone][zoneNumber]['Type'] == "rules:genealogical_archives") {
					zoneData[worldOfZone][zoneNumber]['Production'] = "+1% (:pop)";
				}

				// Space elevator doesn't produce but isn't empty
				if(zoneData[worldOfZone][zoneNumber]['Type'] == "rules:space_elevator") {
					zoneData[worldOfZone][zoneNumber]['Production'] = "+2 orbit";
					zoneData[worldOfZone][zoneNumber]['Breakdown'] = "Space Elevator";
				}
			
				// read breakdown if not already set for special types
				if(!zoneData[worldOfZone][zoneNumber]['Breakdown']) {
					// if there is a production breakdown, use that, if not but there is production, its an augmentation zone (specials are already filtered), otherwise the zone is unclaimed
					if(zones[zoneIndex]['Production Breakdown']) {
						zoneData[worldOfZone][zoneNumber]['Breakdown'] = zones[zoneIndex]['Production Breakdown'][0];
					} else if(zones[zoneIndex]['Production']) {
						zoneData[worldOfZone][zoneNumber]['Breakdown'] = "Augmentation Zone: " + zones[zoneIndex]['Production'][0];
					}
				}

				if(zones[zoneIndex]['Limitations']) {
					zoneData[worldOfZone][zoneNumber]['Limitations'] = zones[zoneIndex]['Limitations'];
				}
			
				if(zones[zoneIndex]['Upgrades']) {
					zoneData[worldOfZone][zoneNumber]['Upgrades'] = zones[zoneIndex]['Upgrades'];
				}

				if(zones[zoneIndex]['Specialised']) {
					zoneData[worldOfZone][zoneNumber]['Corporation'] = zones[zoneIndex]['Specialised'][0];
				}

				zoneNumbers[worldOfZone]++;
			}


			$('#leftmenuheader').html("<h3>" + bestEffortWikiLink(system) + "</h3>");

			var table = "";
			table += "<table><tr><th></th><th>Orbit</th><th>Celestial Body</th></tr>";

			for(var worldIndex in orbitals) {
				table += makeSystemEntry(orbitals[worldIndex]);
			}

			table += "</table>";
	
			$('#leftmenucontent').html('');

			$('#leftmenucontent').append(table);

			if(world) {
				clickOrbital(world);
			}
			$('#waitingicon').html('');

		}
	}); 

})

function clickOrbital(orbitalClicked) {
	if(!orbitals[orbitalClicked]) {
		$('#planetTitle').html("Invalid World Selected");
	} else {
		loadZones(orbitalClicked, orbitals[orbitalClicked]['image'], orbitals[orbitalClicked]['world type'], orbitals[orbitalClicked]['zones'], orbitals[orbitalClicked]['title']);	
		fillProduction(orbitalClicked);
		fillDefences(orbitalClicked);
	}
}

function makeSystemEntry(entryObject) {
	var str = "<tr class='" + entryObject['class'] + "_table_entry'>";
	str += "<td style='width:48px;'><img src='/dokuwiki/_media/" + entryObject['image'] + "?w=48&h=48' /></td>";
	str += "<td>" + (entryObject['Index'] != "0" ? entryObject['index'] : "") + "</td>";
	str += "<td><u><a style='cursor: pointer;' onclick='clickOrbital(\"" + entryObject['name'] +"\")'>" + entryObject['title'] + "</a></u><span class='rightalign'>[ <a href='/dokuwiki/" + entryObject['name'] + "'>Wiki</a> ]</td>";
	return str;
}

function displayZoneData(world, zoneNumber) {

	var table = "<table cellpadding='0' cellspacing='0'>";
	table += "<tr><th>" + zoneData[world][zoneNumber]['entry title'] + " (" + bestEffortWikiLink(zoneData[world][zoneNumber]['PlanetRef']) + " - " + bestEffortWikiLink(system) + ")</th></tr>"
	table += "<tr><td class='middle_right'>";

	var prod = fixIconHtml(zoneData[world][zoneNumber]['Production']);
	
	// fix manual edits on overview
	if(zoneData[world][zoneNumber]['Production'] == "Fleet" || zoneData[world][zoneNumber]['Production'] == "Empty" || zoneData[world][zoneNumber]['Production'] == "+6 :dot1:" || zoneData[world][zoneNumber]['Production'] == "+1% (:pop)") {
		prod = "";
	}


	var typeStr = bestEffortWikiLink(zoneData[world][zoneNumber]['Type']);

	if(zoneData[world][zoneNumber]['Type'].toLowerCase() == "rules:unclaimed") {
		typeStr = "Undeveloped zone"
	}

	table += prod + " " + typeStr + ": " + bestEffortDoWikiStrings(zoneData[world][zoneNumber]['Description']);

	if(zoneData[world][zoneNumber]['Breakdown']) {
		table += "<br/><br/><i>" + bestEffortDoWikiStrings(zoneData[world][zoneNumber]['Breakdown']) + "</i>";
	}

	if(zoneData[world][zoneNumber]['Upgrades']) {
		table += "<br/><br/>Upgrades: ";

		var first = true;
		for(var up in zoneData[world][zoneNumber]['Upgrades']) {
			if(first) {
				first = false;
			} else {
				table += ", ";
			}
			table += bestEffortWikiLink(zoneData[world][zoneNumber]['Upgrades'][up]);
		} 
 	}

	if(zoneData[world][zoneNumber]['Corporation']) {
		table += "<br/><br/>Specialised by: " + bestEffortWikiLink(zoneData[world][zoneNumber]['Corporation']);
	}

	if(zoneData[world][zoneNumber]['Limitations']) {
		table += "<br/><br/>";

		var first = true;
		for(var index in zoneData[world][zoneNumber]['Limitations']) {
			if(first) {
				first = false;
			} else {
				table += ", ";
			}
			table += bestEffortDoWikiStrings(zoneData[world][zoneNumber]['Limitations'][index]);
		} 
	}

	// Specials aren't done since currently there are no specials on zones

	table += "</td></tr>";
	table += "<tr><td class='bottom_right'>(Controlled by the " + bestEffortWikiLink(faction) + ")<span class='right_float'>[ <a href='/dokuwiki/" + zoneData[world][zoneNumber]['PlanetRef'] + "?do=edit'>Edit</a> ]</span></td></tr>";
	table += "</table>";

	$('#rightinfoboxcontent').html(table);
	
}

// actual function to load zones. World is the wiki name of the planet page (i.e. ic:mirda)

function loadZones(world, image, worldType, numberOfZones, properName) {
	
	$("#planetTitle").html(properName);
	document.title = properName + " Zone Overview \u2022 Free Worlds Union";

	$("#rightinfoboxheader").html("<h3>" + properName + " Zone Details</h3>");

	$("#zones").css('background-image', 'url(/dokuwiki/_media/' + image + ')');
	
	$("#zones").attr('class', replaceAll(worldType, " ", "_"));
	
	// set all circles inactive, clear inner html and title attribute
	$(".circle").attr('class', "circle inactive").html("").attr('title', "");
	
	// switch by world type to activate the correct sections
	switch(worldType) {
		case "rules:large_planet":
			$("#circle_1_2").removeClass("inactive");
			$("#circle_1_3").removeClass("inactive");
			$("#circle_1_4").removeClass("inactive");
			$("#circle_1_5").removeClass("inactive");
			$("#circle_2_2").removeClass("inactive");
			$("#circle_2_6").removeClass("inactive");
			$("#circle_3_1").removeClass("inactive");
			$("#circle_3_6").removeClass("inactive");
			$("#circle_4_1").removeClass("inactive");
			$("#circle_4_7").removeClass("inactive");
			$("#circle_5_1").removeClass("inactive");
			$("#circle_5_6").removeClass("inactive");
			$("#circle_6_2").removeClass("inactive");
			$("#circle_6_6").removeClass("inactive");
			$("#circle_7_2").removeClass("inactive");
			$("#circle_7_3").removeClass("inactive");
			$("#circle_7_4").removeClass("inactive");
			$("#circle_7_5").removeClass("inactive");
			numberOfZones -= 18;
		case "rules:medium_planet":
			$("#circle_2_3").removeClass("inactive");
			$("#circle_2_4").removeClass("inactive");
			$("#circle_2_5").removeClass("inactive");
			$("#circle_3_2").removeClass("inactive");
			$("#circle_3_5").removeClass("inactive");
			$("#circle_4_2").removeClass("inactive");
			$("#circle_4_6").removeClass("inactive");
			$("#circle_5_2").removeClass("inactive");
			$("#circle_5_5").removeClass("inactive");
			$("#circle_6_3").removeClass("inactive");
			$("#circle_6_4").removeClass("inactive");
			$("#circle_6_5").removeClass("inactive");
			numberOfZones -= 12;
		case "rules:small_planet":
		case "rules:large_moon":
			$("#circle_4_3").removeClass("inactive");
			$("#circle_4_5").removeClass("inactive");
			$("#circle_5_3").removeClass("inactive");
			$("#circle_5_4").removeClass("inactive");
			numberOfZones -= 4;
		case "rules:brown_dwarf":
		case "rules:jovian_giant":
		case "rules:ice_giant":
		case "rules:medium_moon":
			$("#circle_3_3").removeClass("inactive");
			$("#circle_3_4").removeClass("inactive");
			numberOfZones -= 2;
		case "rules:small_moon":
			$("#circle_4_4").removeClass("inactive");
			numberOfZones -= 1;
			break;
		case "rules:rings":
			$("#circle_5_3").removeClass("inactive");
			$("#circle_5_4").removeClass("inactive");
			numberOfZones -= 2;
			break;
		case "rules:trojan_asteroids":
			$("#circle_4_2").removeClass("inactive");
			$("#circle_4_6").removeClass("inactive");
			numberOfZones -= 2;
			break;
		case "rules:asteroid_belt":
			$("#circle_3_1").removeClass("inactive");
			$("#circle_4_1").removeClass("inactive");
			$("#circle_4_3").removeClass("inactive");
			$("#circle_4_6").removeClass("inactive");
			$("#circle_4_7").removeClass("inactive");
			$("#circle_5_4").removeClass("inactive");
			numberOfZones -= 6;
			break;
		default:
			// presume star - no zones
			break;
	}

	if(isNaN(numberOfZones)) {
		alert("Your orbital does not list its number of zones correctly. Please correct this in the wiki.");
	}

	for(var i = 0; i < numberOfZones; i++) {
		$("#circle_s" + i).removeClass("inactive");
	}


	// keep an index number
	var numIndex = 1;
		
	// filter all circles that aren't inactive and sort them by id (this fills zones up from top left to bottom right, and then underworld.
	$('.circle').not('.inactive').sort(function(a,b) {
		var compA = $(a).attr('id');
		var compB = $(b).attr('id');
		return (compA < compB) ? -1 : (compA > compB) ? 1 : 0;
	}).each(function() {

		// if there is data for the zone
		if(zoneData[world][numIndex]) {
			// fill in the type as a class for the zone
			var type = zoneData[world][numIndex]['Type'].substring(6);
			$(this).attr('class', type + " circle");
			// set production breakdown as mouseover text
			$(this).attr('title', zoneData[world][numIndex]['entry title']);
			// fill content with production
			$(this).html("<div class='innertext'><div>" + fixIconHtml(zoneData[world][numIndex]['Production']) + "</div></div>");
				
			if(zoneData[world][numIndex]['Limitations']) {
				for(var i in zoneData[world][numIndex]['Limitations']) {
					if(zoneData[world][numIndex]['Limitations'][i].toLowerCase().indexOf('metals only') !== -1 
							|| zoneData[world][numIndex]['Limitations'][i].toLowerCase().indexOf('(:metals) only') !== -1) {
						$(this).addClass('metals_only');
					}
					if(zoneData[world][numIndex]['Limitations'][i].toLowerCase().indexOf('gasses only') !== -1 
							|| zoneData[world][numIndex]['Limitations'][i].toLowerCase().indexOf('(:gasses) only') !== -1
							|| zoneData[world][numIndex]['Limitations'][i].toLowerCase().indexOf('(:gas) only') !== -1) {
						$(this).addClass('gasses_only');
					}
				}
			}
				
			$(this).attr('onClick', '$(".circle").removeClass("selected");$(this).addClass("selected");displayZoneData(\"' + world + "\", " + numIndex + ');');

			// fill next zone
			numIndex++;
		}
	});
	//$('#zones').html(total);
	

}

/**
 * Fixes HTML icons
 */
function fixIconHtml(str) {
	str = str.replace(/:dot10:/g, "&#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;&#9679;&#9679;");
	str = str.replace(/:dot11:/g, "&#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;&#9679;&#9679; &#9679;");
	str = str.replace(/:dot12:/g, "&#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;");
	str = str.replace(/:dot13:/g, "&#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;");
	str = str.replace(/:dot14:/g, "&#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;&#9679;");
	str = str.replace(/:dot15:/g, "&#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;&#9679;&#9679;");
	str = str.replace(/:dot16:/g, "&#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;&#9679;&#9679; &#9679;");
	str = str.replace(/:dot17:/g, "&#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;");
	str = str.replace(/:dot18:/g, "&#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;");
	str = str.replace(/:dot19:/g, "&#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;&#9679;");
	str = str.replace(/:dot20:/g, "&#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;&#9679;&#9679;");
	str = str.replace(/:dot0:/g, "&#9675;");
	str = str.replace(/:dot1:/g, "&#9679;");
	str = str.replace(/:dot2:/g, "&#9679;&#9679;");
	str = str.replace(/:dot3:/g, "&#9679;&#9679;&#9679;");
	str = str.replace(/:dot4:/g, "&#9679;&#9679;&#9679;&#9679;");
	str = str.replace(/:dot5:/g, "&#9679;&#9679;&#9679;&#9679;&#9679;");
	str = str.replace(/:dot6:/g, "&#9679;&#9679;&#9679;&#9679;&#9679; &#9679;");
	str = str.replace(/:dot7:/g, "&#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;");
	str = str.replace(/:dot8:/g, "&#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;");
	str = str.replace(/:dot9:/g, "&#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;&#9679;");
	return fwurg.icons.render(str);
}

function bestEffortDoWikiStrings(text) {
	while(text.indexOf("[[") >= 0 && text.indexOf("]]") >=0 && text.indexOf("]]") > text.indexOf("[[")) {
		var before = text.substring(0, text.indexOf("[["));
		var after = text.substring(text.indexOf("]]") + 2);
		
		var between = text.substring(text.indexOf("[[") + 2, text.indexOf("]]"));
		if(between.indexOf("|") >= 0) {
			var link = between.substring(0, between.indexOf("|"));
			var alt = between.substring(between.indexOf("|") + 1);
			text = before + bestEffortWikiLink(link, alt) + after;
		} else {
			text = before + bestEffortWikiLink(between) + after;
		}
	}

	return fixIconHtml(text);
}

/**
 * Do a best effort parsing of the wiki link to human readable format as a link. 
 * altText is an optional variable.
 */
function bestEffortWikiLink(link, altText) {
	var replaced = "";
	if(!altText) {

		replaced = link;

		if(replaced.indexOf("#") >= 0) {
			if(replaced.indexOf("#") < replaced.length - 1) {
				replaced = replaced.substring(replaced.indexOf("#") + 1);
			} else {
				replaced = replaced.substring(0, replaced.indexOf("#"));
			}
		}

		while(replaced.indexOf(":") >= 0) {
			replaced = replaced.substring(replaced.indexOf(":") + 1);
		}

		while(replaced.indexOf("_") >= 0) {
			var num = replaced.indexOf("_");
			replaced = replaced.substring(0, num) 
					+ " " 
					+ replaced.substring(num + 1, num + 2).toUpperCase()
					+ replaced.substring(num + 2);
		}

		replaced = replaced.substring(0, 1).toUpperCase() + replaced.substring(1);	
	} else {
		replaced = altText;
	}

	var str = "<a href='/dokuwiki/" + link + "'>" + replaced + "</a>"
	return str;
}

// Replace all function doesn't exist in javascript String prototype o_O
function replaceAll(source,stringToFind,stringToReplace){
	var temp = source;
	var index = temp.indexOf(stringToFind);
	while(index != -1){
		temp = temp.replace(stringToFind,stringToReplace);
		index = temp.indexOf(stringToFind);
	}
	return temp;
}




/* ********************************************************************
* Alphanum sort() function version - case insensitive
*  - Slower, but easier to modify for arrays of objects which contain
*    string properties
*
*/
function alphanumCase(a, b) {
  function chunkify(t) {
    var tz = new Array();
    var x = 0, y = -1, n = 0, i, j;

    while (i = (j = t.charAt(x++)).charCodeAt(0)) {
      var m = (i == 46 || (i >=48 && i <= 57));
      if (m !== n) {
        tz[++y] = "";
        n = m;
      }
      tz[y] += j;
    }
    return tz;
  }

  var aa = chunkify(a.toLowerCase());
  var bb = chunkify(b.toLowerCase());

  for (x = 0; aa[x] && bb[x]; x++) {
    if (aa[x] !== bb[x]) {
      var c = Number(aa[x]), d = Number(bb[x]);
      if (c == aa[x] && d == bb[x]) {
        return c - d;
      } else return (aa[x] > bb[x]) ? 1 : -1;
    }
  }
  return aa.length - bb.length;
}

function fillDefences(world) {

	var str = "";

	str += "<table style='text-align:center'>";
	str += "<tr><th colspan=6>Combat Statistics</th></tr><tr>";
	str += "<th>" + fixIconHtml("(:outer-offence)") + "</th>";
	str += "<td>";
	str += fixIconHtml(":dot" + orbitals[world]['outer-offence'] + ":");
	str += "</td>"; 
	str += "<th>" + fixIconHtml("(:middle-offence)") + "</th>";
	str += "<td>";
	str += fixIconHtml(":dot" + orbitals[world]['middle-offence'] + ":");
	str += "</td>"; 
	str += "<th>" + fixIconHtml("(:inner-offence)") + "</th>";
	str += "<td>";
	str += fixIconHtml(":dot" + orbitals[world]['inner-offence'] + ":");
	str += "</td>"; 
	str += "</tr><tr>";
	str += "<th>" + fixIconHtml("(:outer-defence)") + "</th>";
	str += "<td>";
	str += fixIconHtml(":dot" + orbitals[world]['outer-defence'] + ":");
	str += "</td>"; 
	str += "<th>" + fixIconHtml("(:middle-defence)") + "</th>";
	str += "<td>";
	str += fixIconHtml(":dot" + orbitals[world]['middle-defence'] + ":");
	str += "</td>"; 
	str += "<th>" + fixIconHtml("(:inner-defence)") + "</th>";
	str += "<td>";
	str += fixIconHtml(":dot" + orbitals[world]['inner-defence'] + ":");
	str += "</td>"; 
	str += "</tr>";
	str += "</table>";
	str += "<table style='margin-top:5px;'>";
	str += "<tr><th>Effectiveness</th><td>";
	str += doEffectivenessLevel(orbitals[world]['effectiveness']);
	str += "</td></tr></table>";

	str = replaceAll(str, 'undefined', '0');
	$('#defence_content').html(str);

}

function doEffectivenessLevel(number) {
	number = Number(number);

	if(number > 6 || number < 0) {
		return "Invalid Effectiveness Level: '" + number + "'";
	}
	switch(number) {
		case 0:
			return "-0: &#9746;, -1: &#9746;&#9746;, Incap.: &#9746;&#9746;&#9746;";
		case 1:
			return "-0: &#9746;, -1: &#9746;&#9746;, Incap.: &#9746;&#9746;&#9744;";
		case 2:
			return "-0: &#9746;, -1: &#9746;&#9746;, Incap.: &#9746;&#9744;&#9744;";
		case 3:
			return "-0: &#9746;, -1: &#9746;&#9746;, Incap.: &#9744;&#9744;&#9744;";
		case 4:
			return "-0: &#9746;, -1: &#9746;&#9744;, Incap.: &#9744;&#9744;&#9744;";
		case 5:
			return "-0: &#9746;, -1: &#9744;&#9744;, Incap.: &#9744;&#9744;&#9744;";
		case 6:
			return "-0: &#9744;, -1: &#9744;&#9744;, Incap.: &#9744;&#9744;&#9744;";
		default:
			return "ERROR";
	}

}

function doP(product, raws, prodData) {
	if(prodData[product]) {
		var s = "<td>" + prodData[product] + " " + fixIconHtml("(:"+product+")");
		if(prodData[product + '+corp']) {
			s += "<br/>" + prodData[product + '+corp'] + " " + fixIconHtml("(:"+product+"+corp)");
		}
		s += "</td>"
		raws.push(s);
	} else if(prodData[product+'+corp']) {
		raws.push("<td>" + prodData[product+'+corp'] + " " + fixIconHtml("(:"+product+"+corp)</td>"));
	}
	return raws;
}

function fillProduction(world) {

	var prodData = orbitals[world]['total production'];

	var raws = new Array();

	
	raws = doP('crystals', raws, prodData);
	raws = doP('gasses', raws, prodData);
	raws = doP('information', raws, prodData);
	raws = doP('metals', raws, prodData);
	raws = doP('organics', raws, prodData);
	raws = doP('rare-elements', raws, prodData);

	raws = doP('construction-materials', raws, prodData);
	raws = doP('consumer-goods', raws, prodData);
	raws = doP('electronics', raws, prodData);
	raws = doP('entertainment', raws, prodData);
	raws = doP('exotic-matter-devices', raws, prodData);
	raws = doP('food', raws, prodData);
	raws = doP('healthcare-products', raws, prodData);
	raws = doP('ict-technology', raws, prodData);
	raws = doP('research', raws, prodData);
	raws = doP('utilities', raws, prodData);
	raws = doP('vehicles', raws, prodData);
	raws = doP('weapons', raws, prodData);

	raws = doP('capital-ships', raws, prodData);
	raws = doP('holonet-relays', raws, prodData);
	raws = doP('hyperspace-nodes', raws, prodData);
	raws = doP('mass-transit-cargo-freighters', raws, prodData);
	raws = doP('terraformation-modules', raws, prodData);
	raws = doP('superstructure-components', raws, prodData);

	raws = doP('power', raws, prodData);
	raws = doP('open-market-trade', raws, prodData);


	var str = "";
	str += "<table class='productiontable' style='text-align:center'>";
	str += "<th colspan=3>World Production</th></tr>";
	var i = 0;
	for(var rawIndex in raws) {
		if(i%3 == 0) {
			str += "<tr>";
		}
		str += raws[rawIndex];
		i++;
		if(i%3 == 0) {
			str += "</tr>"
		}
	}
	if(i%3 == 1) {
		str += "<td></td><td></td></tr>";
	}
	if(i%3 == 2) {
		str += "<td></td></tr>";
	}


	str += "</table>";




	str = replaceAll(str, 'undefined', '0');
	$('#production_content').html(str);

}

