/**
 * This function handles the insertion of the image after being selected in the wiki tab - it cleans up the selected name to be in the proper format, sets the value for the data model of this builder and updates the image.
 * 
 * @param varA is always "wiki__text"
 * @param varB is the start of the image tag (including {{: as a start and | as an end
 * @param varC is }}
 * @param varD is an empty string
 */
var insertTags = function(varA, varB, varC, varD) {
	$('#imageFieldEntry').val(varB.substring(3,varB.indexOf("?")));
	newrace.setImage($('#imageFieldEntry').val());
	loadCharImage($('#imageFieldEntry').val());
}

function loadCharImage(image) {
	$('#raceImage').attr("src", "/dokuwiki/_media/" + image);
}

function Racial(racialName, racialImage, racialBonus, racialJediBonus) {
	// race name
	this.name = racialName;
	
	this.getName = function() {
		return this.name;
	}
	
	// image
	this.image = racialImage;
	
	this.getImage = function() {
		return this.image;
	}
	
	// bonus
	this.bonus = racialBonus;
	
	this.getBonus = function() {
		return this.bonus;
	}

	// jedi bonus
	this.jedi = racialJediBonus;
	
	this.getJediBonus = function() {
		return this.jedi;
	}
}

﻿/**
 * Character Constructor.
 */
function NewRace() {
	this.singularName;
	this.setSingularName = function(newSingularName) {
		this.singularName = newSingularName.replace(/^\s\s*/, '').replace(/\s\s*$/, '');
	}
	this.getSingularName = function() {
		return this.singularName;
	}
	
	this.pluralName;
	this.setPluralName = function(newPluralName) {
		this.pluralName = newPluralName.replace(/^\s\s*/, '').replace(/\s\s*$/, '');
	}
	this.getPluralName = function() {
		return this.pluralName;
	}

	this.user; // auto-read out?
	this.setUser = function(newUser) {
		this.user = newUser.replace(/^\s\s*/, '').replace(/\s\s*$/, '');
	}
	this.getUser = function() {
		return this.user;
	}

	this.augmented = false;
	this.setAugmented = function(augmentedStatus) {
		this.augmented = augmentedStatus;
		this.disableOverLimit();
	}
	this.isAugmented = function() {
		return this.augmented;
	}

	this.cutIllegalCharacteristics = function() {
		if(this.isAugmented() && this.racialCharacteristics.length > 4) {
			for(racialIndex in this.racialCharacteristics.slice(4)) {
				$('#racials .select').filter(function() {
					return $(this).data("racial") == newrace.racialCharacteristics[(parseInt(racialIndex)+3)];
				}).click();
			}
		} else if (!this.isAugmented() && this.racialCharacteristics.length > 3) {
			for(racialIndex in this.racialCharacteristics.slice(3)) {
				$('#racials .select').filter(function() {
					return $(this).data("racial") == newrace.racialCharacteristics[(parseInt(racialIndex)+3)];
				}).click();
			}
		}
		
	}
	
	this.homeworld;
	this.setHomeworld = function(newHomeworld) {
		this.homeworld = newHomeworld.replace(/^\s\s*/, '').replace(/\s\s*$/, '');
	}
	this.getHomeworld = function() {
		return this.homeworld;
	}

	this.image = 'ic:default-race.png'; // upload to wiki and fill in
	this.setImage = function(newImage) {
		this.image = newImage.replace(/^\s\s*/, '').replace(/\s\s*$/, '');
	}
	this.getImage = function() {
		return this.image;
	}
	
	this.racialCharacteristics = new Array(0);
	
	this.getRacialCharacteristics = function() {
		return this.racialCharacteristics;
	}
	
	this.containsRacialCharacteristic = function(toCheck) {
		var i;
		for (i=0; i<this.racialCharacteristics.length; i++) {
			if(this.racialCharacteristics[i] == toCheck) {
				return true;
			}
		}
		return false;
	}
	
	this.disableOverLimit = function() {
		if((this.isAugmented() && this.racialCharacteristics.length >= 4) || (!this.isAugmented() && this.racialCharacteristics.length >= 3)) {
			// disable everything else
			disableUnselectedRacialCharacteristics();
		} else {
			enableUnselectedRacialCharacteristics();
		}	
		this.cutIllegalCharacteristics();
	}
	
	
	this.toggleRacialCharacteristic = function(toToggle) {
		if(!this.containsRacialCharacteristic(toToggle)) {
			// add
			var l = this.racialCharacteristics.length;
			this.racialCharacteristics.length += 1;
			this.racialCharacteristics[l] = toToggle;
			this.racialCharacteristics.sort();
		} else {
			// remove
			var index = -1;
			var i;
			for (i=0; i<this.racialCharacteristics.length; i++) {
				if(this.racialCharacteristics[i] == toToggle) {
					index = i;
				}
			}
			if(index >= 0) {
				this.racialCharacteristics.splice(index, 1);
			}
		}
		this.disableOverLimit();
	}

		
	this.toWikiString = function() {
		var text = "====== " + this.getSingularName() + " ======\n\n";
		text += "<data !wip #wip>\n";
		text += "User [ref::user]   : " + this.getUser() + "\n";
		text += "Description [wiki] : Page generated using the [[https://www.fwurg.net/tools/race-builder/racebuilder.php|Race Builder]]\n";
		text += "Page [ref] : [[]]\n";
		text += "</data>\n\n";
		 
		text += "<data !race>\n";
		text += "Description [wiki]             : " + this.getPluralName() + (this.getHomeworld() ? " of " + this.getHomeworld() : "") + "\n";
		text += "Image [image::300]             : " + this.getImage() + "\n";
		text += "Plural                         : " + this.getPluralName() + "\n";
		text += "Racial Characteristics [rule]* : " + this.getRacialCharacteristics() + "\n";
		text += "Homeworld [ref]                : " + (this.getHomeworld() ? this.getHomeworld() : "") + "\n";
		text += "</data>\n\n";
		text += "YOUR DESCRIPTION HERE!\n";
		
		return text;
	}
}

function disableUnselectedRacialCharacteristics() {
	$('#racials .select').filter(function() {
		if(!newrace.containsRacialCharacteristic($(this).data("racial"))) {
			return true;
		}
	}).addClass("disabled");
}
function enableUnselectedRacialCharacteristics() {
	$('#racials .select').filter(function() {
		if(!newrace.containsRacialCharacteristic($(this).data("racial"))) {
			return true;
		}
	}).removeClass("disabled");
}

function addRacialCharacteristic(racial) {
	var html = '';
		html += '<div data-racial="' + racial.getName() + '" class=\'select\'>';
		html += '<img class=\'selectimage\' src=\'/dokuwiki/_media/' + racial.getImage() + '?w=64\'></img>';
		html += '<table class=\'tinytable\'>';
		html += '<tr><th colspan=2 style="padding-left:2px;"><a href="/dokuwiki/rules:' + racial.getName() + '" target="_blank">';
		html += racial.getName();
		html += '</a></th></tr><tr><td style="width:72px;">Economy Boost:</td><td>';
		html += doWikiParse(racial.getBonus());
		html += '</td></tr><tr><td>Jedi Boost:</td><td>'
		html += doWikiParse(racial.getJediBonus());
		html += '</td></tr></table></div>'

	$('#racials').append(html);
	
}

$(function() {
	// initialize new wiki object
	var wiki = new fwurg.Wiki();
	var qb = wiki.qb();
	wiki.queryResources(qb.query(
		qb.fields('?r'),
		qb.where(
			'?r is a: racialCharacteristic',
			'minus {',
			'  ?w is a: wip',
			'  ?w Page[ref]: ?r',
			'}'
		)
	)).then(function(data) {
		var racials = data.body;
		var sortedRacials = new Array();
		for(var k in racials) {
			sortedRacials[k] = racials[k]['entry title'][0];
		}
		sortedRacials.sort();
		for(var k in sortedRacials) {
			addRacialCharacteristic(new Racial(racials[k]['entry title'][0], racials[k]['Image'][0], racials[k]['Bonus'][0], racials[k]['Jedi'][0]));
		}
		$('#racials .select').click(function() {
			if(!$(this).hasClass("disabled")) {
				newrace.toggleRacialCharacteristic($(this).data("racial"));
				$(this).toggleClass("selected");
			
			}
		});
	});

})

function replaceAll(Source,stringToFind,stringToReplace){
	var temp = Source;
	var index = temp.indexOf(stringToFind);
	while(index != -1){
		temp = temp.replace(stringToFind,stringToReplace);
		index = temp.indexOf(stringToFind);
	}
	return temp;
}

function doWikiParse(str) {
	// wiki links
	while(str.indexOf("[[") != -1) {
		// still links to replace
		var iStart = str.indexOf("[[");
		var iEnd = str.indexOf("]]");
		var iBar = str.indexOf("|", iStart);
		// sanity check
		if(iEnd < iStart) {
			//illegal wiki string, don't do any replacements
			continue;
		}
		if(iBar != -1 && iBar < iEnd) {
			var actualLink = str.substr(iStart + 2, (iBar - 2 - iStart));
			var title = str.substr(iBar + 1, (iEnd - iBar -1));
			var fullLink = str.substr(iStart, (iEnd+2 - iStart));
			str = str.replace(fullLink, "<a target='_blank' href='/dokuwiki/" + actualLink + "'>" + title + "</a>");
		} else {
			var actualLink = str.substr(iStart + 2, (iEnd-2 - iStart));
			var fullLink = str.substr(iStart, (iEnd+2 - iStart));
			var title = actualLink.substr(actualLink.lastIndexOf(":") + 1,actualLink.lastIndexOf("#"))
			title = title.substring(0, title.length - 1);
			title = replaceAll(title, "_", " ");
			title = title.replace(/\w\S*/g, function(txt){return txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase();});

			str = str.replace(fullLink, "<a target='_blank' href='/dokuwiki/" + actualLink + "'>" + title + "</a>");
		}		
	}
	
	// icons (manual hax for links and images)
	str = replaceAll(str, "(:special-point)", "<a target='_blank' href='/dokuwiki/rules:special_points' title='Special Points'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/special.png' /></a>");
	str = replaceAll(str, "(:gas-mass)", "<a target='_blank' href='/dokuwiki/rules:gas_mass' title='Gas Mass'><img class='icon' src='/dokuwiki/rules:gas_mass' /></a>");
	str = replaceAll(str, "(:rock-mass)", "<a target='_blank' href='/dokuwiki/rules:rock_mass' title='Rock Mass'><img class='icon' src='/dokuwiki/rules:rock_mass' /></a>");
	str = replaceAll(str, "(:bio-mass)", "<a target='_blank' href='/dokuwiki/rules:bio_mass' title='Bio Mass'><img class='icon' src='/dokuwiki/rules:bio_mass' /></a>");
	str = replaceAll(str, "(:cold-orbit)", "<a target='_blank' href='/dokuwiki/rules:cold_orbit' title='Cold Orbit'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/orbit-cold.png' /></a>");
	str = replaceAll(str, "(:gold-orbit)", "<a target='_blank' href='/dokuwiki/rules:goldilocks_orbit' title='Goldilocks Orbit'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/orbit-gold.png' /></a>");
	str = replaceAll(str, "(:goldilocks-orbit)", "<a target='_blank' href='/dokuwiki/rules:goldilocks_orbit' title='Goldilocks Orbit'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/orbit-gold.png' /></a>");
	str = replaceAll(str, "(:hot-orbit)", "<a target='_blank' href='/dokuwiki/rules:hot_orbit' title='Hot Orbit'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/orbit-hot.png' /></a>");
	str = replaceAll(str, "(:lunar-orbit)", "<a target='_blank' href='/dokuwiki/rules:lunar_orbit' title='Lunar Orbit'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/orbit-lunar.png' /></a>");
	str = replaceAll(str, "(:tax)", "<a target='_blank' href='/dokuwiki/rules:taxes' title='Taxes'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/tax.png' /></a>");
	str = replaceAll(str, "(:turn)", "<a target='_blank' href='/dokuwiki/rules:turn' title='Turns'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/turns.png' /></a>");
	str = replaceAll(str, "(:turns)", "<a target='_blank' href='/dokuwiki/rules:turn' title='Turns'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/turns.png' /></a>");
	str = replaceAll(str, "(:hex)", "<a target='_blank' href='/dokuwiki/rules:hex' title='Hex'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/hex-distance.png' /></a>");
	str = replaceAll(str, "(:pop)", "<a target='_blank' href='/dokuwiki/rules:population' title='Population'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/population.png' /></a>");
	str = replaceAll(str, "(:population)", "<a target='_blank' href='/dokuwiki/rules:population' title='Population'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/population.png' /></a>");
	str = replaceAll(str, "(:power)", "<a target='_blank' href='/dokuwiki/rules:power' title='Power'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/power.png' /></a>");
	str = replaceAll(str, "(:conmats)", "<a target='_blank' href='/dokuwiki/rules:construction_materials' title='Construction Materials'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/product-construction-materials.png' /></a>");
	str = replaceAll(str, "(:construction-materials)", "<a target='_blank' href='/dokuwiki/rules:construction_materials' title='Construction Materials'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/product-construction-materials.png' /></a>");
	str = replaceAll(str, "(:congoods)", "<a target='_blank' href='/dokuwiki/rules:consumer_goods' title='Consumer Goods'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/product-consumer-goods.png' /></a>");
	str = replaceAll(str, "(:consumer-goods)", "<a target='_blank' href='/dokuwiki/rules:consumer_goods' title='Consumer Goods'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/product-consumer-goods.png' /></a>");
	str = replaceAll(str, "(:electronics)", "<a target='_blank' href='/dokuwiki/rules:electronics' title='Electronics'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/product-electronics.png' /></a>");
	str = replaceAll(str, "(:entertainment)", "<a target='_blank' href='/dokuwiki/rules:entertainment' title='Entertainment'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/product-entertainment.png' /></a>");
	str = replaceAll(str, "(:emds)", "<a target='_blank' href='/dokuwiki/rules:exotic_matter_devices' title='Exotic Matter Devices'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/product-exotic-matter-devices.png' /></a>");
	str = replaceAll(str, "(:exotic-matter-devices)", "<a target='_blank' href='/dokuwiki/rules:exotic_matter_devices' title='Exotic Matter Devices'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/product-exotic-matter-devices.png' /></a>");
	str = replaceAll(str, "(:food)", "<a target='_blank' href='/dokuwiki/rules:food' title='Food'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/product-food.png' /></a>");
	str = replaceAll(str, "(:healthcare)", "<a target='_blank' href='/dokuwiki/rules:healthcare_products' title='Healthcare Products'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/product-healthcare-products.png' /></a>");
	str = replaceAll(str, "(:healthcare-products)", "<a target='_blank' href='/dokuwiki/rules:healthcare_products' title='Healthcare Products'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/product-healthcare-products.png' /></a>");
	str = replaceAll(str, "(:ict)", "<a target='_blank' href='/dokuwiki/rules:ict_technology' title='ICT Technology'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/product-ict-technology.png' /></a>");
	str = replaceAll(str, "(:ict-technology)", "<a target='_blank' href='/dokuwiki/rules:ict_technology' title='ICT Technology'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/product-ict-technology.png' /></a>");
	str = replaceAll(str, "(:research)", "<a target='_blank' href='/dokuwiki/rules:research' title='Research'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/product-research.png' /></a>");
	str = replaceAll(str, "(:utilities)", "<a target='_blank' href='/dokuwiki/rules:utilities' title='Utilities'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/product-utilities.png' /></a>");
	str = replaceAll(str, "(:vehicles)", "<a target='_blank' href='/dokuwiki/rules:vehicles' title='Vehicles'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/product-vehicles.png' /></a>");
	str = replaceAll(str, "(:weapons)", "<a target='_blank' href='/dokuwiki/rules:weapons' title='Weapons'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/product-weapons.png' /></a>");
	str = replaceAll(str, "(:crystals)", "<a target='_blank' href='/dokuwiki/rules:crystals' title='Crystals'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/raw-crystals.png' /></a>");
	str = replaceAll(str, "(:gas)", "<a target='_blank' href='/dokuwiki/rules:gasses' title='Gasses'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/raw-gasses.png' /></a>");
	str = replaceAll(str, "(:gasses)", "<a target='_blank' href='/dokuwiki/rules:gasses' title='Gasses'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/raw-gasses.png' /></a>");
	str = replaceAll(str, "(:information)", "<a target='_blank' href='/dokuwiki/rules:information' title='Information'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/raw-information.png' /></a>");
	str = replaceAll(str, "(:metals)", "<a target='_blank' href='/dokuwiki/rules:metals' title='Metals'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/raw-metals.png' /></a>");
	str = replaceAll(str, "(:organics)", "<a target='_blank' href='/dokuwiki/rules:organics' title='Organics'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/raw-organics.png' /></a>");
	str = replaceAll(str, "(:rares)", "<a target='_blank' href='/dokuwiki/rules:rare_elements' title='Rare Elements'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/raw-rare-elements.png' /></a>");
	str = replaceAll(str, "(:rare-elements)", "<a target='_blank' href='/dokuwiki/rules:rare_elements' title='Rare Elements'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/raw-rare-elements.png' /></a>");
	str = replaceAll(str, "(:cargo)", "<a target='_blank' href='/dokuwiki/rules:trade_capacity' title='Trade Capacity'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/trade-capacity.png' /></a>");
	str = replaceAll(str, "(:tradecap)", "<a target='_blank' href='/dokuwiki/rules:trade_capacity' title='Trade Capacity'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/trade-capacity.png' /></a>");
	str = replaceAll(str, "(:trade-capacity)", "<a target='_blank' href='/dokuwiki/rules:trade_capacity' title='Trade Capacity'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/trade-capacity.png' /></a>");
	str = replaceAll(str, "(:mtcf)", "<a target='_blank' href='/dokuwiki/rules:mass_transit_cargo_freighters' title='Mass Transit Cargo Freighters'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/special-mass-transit-cargo-freighters.png' /></a>");
	str = replaceAll(str, "(:freighters)", "<a target='_blank' href='/dokuwiki/rules:mass_transit_cargo_freighters' title='Mass Transit Cargo Freighters'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/special-mass-transit-cargo-freighters.png' /></a>");
	str = replaceAll(str, "(:mass-transit-cargo-freighters)", "<a target='_blank' href='/dokuwiki/rules:mass_transit_cargo_freighters' title='Mass Transit Cargo Freighters'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/special-mass-transit-cargo-freighters.png' /></a>");
	str = replaceAll(str, "(:holonet-relays)", "<a target='_blank' href='/dokuwiki/rules:holonet%20relays' title='Holonet Relays'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/special-holonet-relays.png' /></a>");
	str = replaceAll(str, "(:hyperspace-nodes)", "<a target='_blank' href='/dokuwiki/rules:hyperspace_nodes' title='Hyperspace Nodes'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/special-hyperspace-nodes.png' /></a>");
	str = replaceAll(str, "(:terraform)", "<a target='_blank' href='/dokuwiki/rules:terraformation_modules' title='Terraformation Modules'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/special-terraformation-modules.png' /></a>");
	str = replaceAll(str, "(:terraformation-modules)", "<a target='_blank' href='/dokuwiki/rules:terraformation_modules' title='Terraformation Modules'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/special-terraformation-modules.png' /></a>");
	str = replaceAll(str, "(:capital-ships)", "<a target='_blank' href='/dokuwiki/rules:capital_ships' title='Capital Ships'><img class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/special-capital-ships.png' /></a>");	

	return str;
}

function createPage() {
	//console.log(newrace.getSingularName());
	// sanity checks
	if(!(newrace.getSingularName() && newrace.getSingularName().length > 0) || !(newrace.getPluralName() && newrace.getPluralName().length > 0)) {
		alert("Please enter the singular and plural form of your race's name, for example 'human' and 'humans'.");
		return;
	}

	if(!(newrace.getImage() && newrace.getImage().length > 0)) {
		alert("Please select an image for your race.");
		return;
	}

	if(!((newrace.isAugmented() && newrace.getRacialCharacteristics().length >= 4) ||
		(!newrace.isAugmented() && newrace.getRacialCharacteristics().length >= 3))) {
		alert("You can still select more racial characteristics! You can select three or, if you have an augmented species, you can select four.");
		return;
	}


    var form = document.createElement("form");
    form.setAttribute("method", "post");
    form.setAttribute("action", "/dokuwiki/ic:" + newrace.getSingularName().replace(":", "_").replace(";", "_"));

    var action = document.createElement("input");
    action.setAttribute("type", "hidden");
    action.setAttribute("name", "do");
    action.setAttribute("value","edit");
    form.appendChild(action);

    var wikitext = document.createElement("textarea");
    wikitext.setAttribute("name", "wikitext");
    wikitext.setAttribute("style", "display:none;");
    $(wikitext).text(newrace.toWikiString());
    form.appendChild(wikitext);

    document.body.appendChild(form);
    form.submit();

}
