// initialise data objects
var starDataObject = false;
var worldsDataObject = false;
var zonesDataObject = false;
var populationsDataObject = false;
var virtualRaces = false;
var numberOfLagrangePointStations = -1;
var systemHasAShortage = false;
var systemHasBrownoutZones = false;

var powerString = "";
var powerPlusString = "";
var powerMinString = "";


// Temporary start up function to select system
$(function() {

	// fix powerString, powerPlusString and powerMinString 
	powerString = fwurg.icons.draw("power");
	powerPlusString = fwurg.icons.draw("power+plus");
	powerMinString = fwurg.icons.draw("power+min");

	// load system from GET data (POST does not work for js)
	var getParameters = new Array();
	
	var query = window.location.search.substring(1);
	query = decodeURI(query);
	
	var params = query.split('&');
	for (var entry in params) {
		var pos = params[entry].indexOf('=');
		if (pos > 0) {
			var key = params[entry].substring(0,pos);
			var val = params[entry].substring(pos+1);
			getParameters[key] = val;
		}
	}

	system = getParameters['system'];

	var systemname = system.split(":")[1];
	systemname = replaceAll(systemname, "_", " ");
	systemname = capString(systemname);
	$('#powertitle').html("<a href='/dokuwiki/" + system + "'>" + systemname + "</a>");

/*	if(!system) {
		$('#planetTitle').html("No world selected");
	} else {
		$('#planetTitle').html("Loading world...");
		$('#waitingicon').html('<div style="height:20px;"><img style="margin-top:32px;margin-left:auto;margin-right:auto;display:block;" src="/images/pod.loading.gif" /></div>');
	}	*/

	// initialize new wiki object
	var wiki = new fwurg.Wiki();
	var qb = wiki.qb();

	// query star in the system
	wiki.queryResources(qb.query(
		qb.fields('?star'),
		qb.where(
			'?star is a: Star',
			'?star system: ' + system
		)
	)).then(function(data) {
		
		var stars = data.body;
		
		if(stars.length > 1) {
			alert("Error: More than one star found meeting the criteria. Binary stars should be formatted as a single data entry. Trinary stars should be listed as planets with a special.");
		}

		var starpower;
		var starorbits;
		var starspecials;
	
		 
	    var star = stars[starIndex];
		for(var starIndex in stars) {
            star = stars[starIndex];
        }
        console.log(star);
		starpower = star['Power Output'];
		starspecials = star['Specials'];
		starorbits = star['Orbits'];

		var tempDataObject = {} ;
		tempDataObject['power'] = {};
		tempDataObject['power']['hot'] = String(star['Power Hot']).trim();
		tempDataObject['power']['gold'] = String(star['Power Goldilocks']).trim();
		tempDataObject['power']['cold'] = String(star['Power Cold']).trim();
		tempDataObject['specials'] = starspecials;
		tempDataObject['orbits'] = {};
		tempDataObject['orbits']['hot'] = String(star['Hot Orbits']).trim();
		tempDataObject['orbits']['gold'] = String(star['Goldilocks Orbits']).trim();
		tempDataObject['orbits']['cold'] = String(star['Cold Orbits']).trim();

		starDataObject = tempDataObject;
			
		fillPowerData();
		
	});	
	
	// query worlds in the system
	wiki.queryResources(qb.query(
		qb.fields('?world'),
		qb.where(
			'?world system: ' + system,
			'union {',
				'{',
					'?world is a: Planet',
				'}',
				'{',
					'?world is a: Moon',
				'}',
			'}',
			qb.optional(
				'?world Orbit Index: ?oi'
			)
		),
		qb.sort(
			'?oi'
		)
	)).then(function(data) {

		var worlds = data.body;
	
		if(worlds.length > 10) {
			alert("Error: Found more than 10 planets. Cannot display this kind of unusual system.");
		}

		var tempDataObject = {};
		
		for(var worldIndex in worlds) {
			var world = worlds[worldIndex];
			
			var worldObject = {};
			worldObject['type'] = world['Type'];
			worldObject['orbit'] = world['Orbit Index'];
			worldObject['orbitType'] = world['Orbit Type'];
			worldObject['specials'] = world['Specials'];
			worldObject['image'] = world['Image'];
			worldObject['link'] = worldIndex;

			if(String(worldObject['orbit']).indexOf(".") <= -1) {
				worldObject['orbit'] = "" + worldObject['orbit'] + ".0";
			}
			
			tempDataObject[worldObject['orbit']] = worldObject;
		}

		worldsDataObject = tempDataObject;
		
		fillPowerData();

	});
	
	// query zones in the system
	wiki.queryResources(qb.query(
		qb.fields('?zone'),
		qb.where(
			'?zone is a: zone',
			'?zone is a: developed',
			'?zone system: ' + system
		)
	)).then(function(data) {

		var zones = data.body;
	
		var tempDataObject = {};
		
		for(var zoneIndex in zones) {
			var zone = zones[zoneIndex];
			
			var zoneObject = {};
			zoneObject['world'] = zone['On'];
			zoneObject['brownout'] = (String(zone['Status']).trim().toLowerCase() == "brownout")
			systemHasBrownoutZones |= zoneObject['brownout'];
			zoneObject['type'] = zone['Type'];
			zoneObject['name'] = zone['entry title'];
			zoneObject['prodbreakdown'] = zone['Production Breakdown'];
			zoneObject['upgrades'] = zone['Upgrades'];
			zoneObject['corp'] = zone['Specialised'];
			zoneObject['special'] = zone['Specials'];
			

			if(zone['Production']) {
				zoneObject['production'] = zone['Production'][0];
			} else {
				zoneObject['production'] = "";
			}
			
			tempDataObject[zoneIndex] = zoneObject;
		}

		
		zonesDataObject = tempDataObject;
		
		fillPowerData();

	});
	
	// query population in the system
	wiki.queryResources(qb.query(
		qb.fields('?population'),
		qb.where(
			'?population is a: population',
			'?population system: ' + system
		)
	)).then(function(data) {

		var populations = data.body;
	
		var tempDataObject = {};
		
		for(var popIndex in populations) {
			var pop= populations[popIndex];
			
			var populationObject = {};
			populationObject['world'] = pop['On'];
			populationObject['race'] = pop['Race'];
			populationObject['number'] = pop['Number'];
			
			tempDataObject[popIndex] = populationObject;
		}

		
		populationsDataObject = tempDataObject;
		
		fillPowerData();

	});	
	
	// get virtual races
	wiki.queryResources(qb.query(
		qb.fields('?race'),
		qb.where(
			'?race is a: Race',
			'?race Racial Characteristics: rules:virtual'
		)
	)).then(function(data) {

		var races = data.body;
	
		var tempDataObject = {};
		
		for(var raceIndex in races) {
			var race = races[raceIndex];
			tempDataObject[raceIndex] = true;
		}

		
		virtualRaces = tempDataObject;
		
		fillPowerData();

	});	
	
		// get virtual races
	wiki.queryResources(qb.query(
		qb.fields('?project'),
		qb.where(
			'?project is a: Completed_Project',
			'?project Special Project: rules:lagrange_point_conduit_stations',
			'?project On: ' + system
		)
	)).then(function(data) {

		var projects = data.body;
		
		var count = 0;
		
		for(var deoxyribonucleicacid in projects) {
			count++;
		}
		
		numberOfLagrangePointStations = count;
		
		fillPowerData();

	});	
	
	
	
	
	
});

function fillPowerData(orbitalClicked) {

	var doubleOrbitLargePlanets = {};

	
	// best effort double work prevention
	if(!starDataObject || !worldsDataObject || !zonesDataObject || !populationsDataObject || (numberOfLagrangePointStations < 0)) {
		// not ready yet - doesn't guarantee double call, but makes reasonably sure and nothing critical breaks regardless.
		return;
	}
	
	// create orbit table array for use with redistribution. this could have been more efficient, but I dont feel like fixing it since its not a hindrance.
	
	var totalOrbitPower = {};
	
	

	// remove load bar
	$('#loadbar').hide();
	// visualise table
	$('#tablemount').show();
	
	var worldToOrbitTable = {};
	
	var orbitsCovered = {};

	// do orbit data
	for(var worldIndex in worldsDataObject) {
		var worldObject = worldsDataObject[worldIndex];
		var orbitIndex = worldIndex.split(".")[0];

		orbitsCovered[orbitIndex] = true;
		
		worldToOrbitTable[worldObject['link']] = orbitIndex;

		$('#orbit_' + orbitIndex).removeClass('unused');
		$('#orbit_' + orbitIndex + "_worlds").append("<a href='/dokuwiki/" + worldObject['link'] + "'><img src='/dokuwiki/_media/" + worldObject['image'] + "?w=48&h=48'/></a>");
		if(!$('#orbit_' + orbitIndex + "_power_produced_breakdown").html()) {
			var orbitPower = 0;
			var subtext = "";
			var notHeavyButLarge = false;
			var orbitClass = String(worldObject['orbitType']).toLowerCase().trim();
			
			// check if Large Planet and not heavy gravity world
			if(String(worldObject['type']).toLowerCase().trim() == "rules:large_planet") {
				var heavy = false;
				for(var specialIndex in worldObject['specials']) {
					if(worldObject['specials'][specialIndex] == "rules:heavy_gravity_world") {
						heavy = true;
					}
				}
				notHeavyButLarge = !heavy;
			}
			if(notHeavyButLarge) {
				if(orbitClass == "rules:hot_orbit") {
					orbitPower = starDataObject['power']['hot'] * 2;
					subtext = "double hot orbit";
				} else if(orbitClass == "rules:cold_orbit") {
					orbitPower = starDataObject['power']['cold'] * 2;
					subtext = "double cold orbit";
				} else {
					// presume goldilocks
					orbitPower = starDataObject['power']['gold'] * 2;
					subtext = "double goldilocks orbit";
				}
				// add note on double orbit in orbit class
				$('#orbit_' + orbitIndex + "_index").html(orbitIndex + " + " + (parseInt(orbitIndex)+1));
				orbitsCovered[(parseInt(orbitIndex) + 1)] = true;
				// save as double orbit
				doubleOrbitLargePlanets[orbitIndex] = "" + orbitIndex + " + " + (parseInt(orbitIndex)+1);
				// fix table colours
				$('#orbit_' + orbitIndex).after("<tr class='unused'></tr>");
			} else {
				if(orbitClass == "rules:hot_orbit") {
					orbitPower = starDataObject['power']['hot'];
					subtext = "hot orbit";
				} else if(orbitClass == "rules:cold_orbit") {
					orbitPower = starDataObject['power']['cold'];
					subtext = "cold orbit";
				} else {
					// presume goldilocks
					orbitPower = starDataObject['power']['gold'];
					subtext = "goldilocks orbit";
				}
				$('#orbit_' + orbitIndex + "_index").html(orbitIndex);
			}
			$('#orbit_' + orbitIndex + "_power_produced_breakdown").html(orbitPower + powerPlusString + "<sub>&nbsp;" + subtext + "</sub>")
		}

		// handle gas giant production
		if(String(worldObject['type']).toLowerCase().trim() == "rules:ice_giant") {
			// ice giants produce 20 power 
			var subtext = "Ice Giant"
			for(var specialIndex in worldObject['specials']) {
				if(String(worldObject['specials'][specialIndex]).toLowerCase() == "rules:chthonian_planet") {
					subtext = "Chthonian (Ice Giant)";
				}				
			}
			
			$('#orbit_' + orbitIndex + "_power_produced_breakdown").append("<br>20" + powerPlusString + "<sub>&nbsp;<a href='/dokuwiki/" + worldObject['link'] + "'>" + subtext + "</a></sub>")
			
		} else if(String(worldObject['type']).toLowerCase().trim() == "rules:jovian_giant") {
			// jovian giants produce 40 power
			var subtext = "Jovian Giant"
			for(var specialIndex in worldObject['specials']) {
				if(String(worldObject['specials'][specialIndex]).toLowerCase() == "rules:chthonian_planet") {
					subtext = "Chthonian (Jovian Giant)";
				}				
			}
			
			$('#orbit_' + orbitIndex + "_power_produced_breakdown").append("<br>40" + powerPlusString + "<sub>&nbsp;<a href='/dokuwiki/" + worldObject['link'] + "'>" + subtext + "</a></sub>")
			
		} else if(String(worldObject['type']).toLowerCase().trim() != "rules:large_planet" &&
				String(worldObject['type']).toLowerCase().trim() != "rules:medium_planet" &&
				String(worldObject['type']).toLowerCase().trim() != "rules:small_planet" &&
				String(worldObject['type']).toLowerCase().trim() != "rules:asteroid_belt" &&
				String(worldObject['type']).toLowerCase().trim() != "rules:large_moon" &&
				String(worldObject['type']).toLowerCase().trim() != "rules:medium_moon" &&
				String(worldObject['type']).toLowerCase().trim() != "rules:small_moon" &&
				String(worldObject['type']).toLowerCase().trim() != "rules:trojan_asteroids" &&
				String(worldObject['type']).toLowerCase().trim() != "rules:rings") {
			// people use 300 different names for trinary stars so eliminate everything else instead of filtering on every single star type, brown dwarf, trinary star, etc.
					
			// brown dwarves pruduce 60 power or 100 if they are trinary stars
			var subtext = "Brown Dwarf";
			var amount = "60";
			for(var specialIndex in worldObject['specials']) {
				if(String(worldObject['specials'][specialIndex]).toLowerCase() == "rules:chthonian_planet") {
					subtext = "Chthonian (Brown Dwarf)";
				} else if(String(worldObject['specials'][specialIndex]).toLowerCase() == "rules:trinary_system") {
					subtext = "Trinary Star";
					amount = "100";
				}
			}
			
			$('#orbit_' + orbitIndex + "_power_produced_breakdown").append("<br>" + amount + powerPlusString + "<sub>&nbsp;<a href='/dokuwiki/" + worldObject['link'] + "'>" + subtext + "</a></sub>")
			
		}
		
		
	}

	// empty orbits (yes this could have been cleaner, but too late now.

	var totalOrbits = parseInt(starDataObject['orbits']['hot']) 
			+ parseInt(starDataObject['orbits']['gold'])
			+ parseInt(starDataObject['orbits']['cold']);

	for(var i = 1; i <= totalOrbits; i++) {
		if(!orbitsCovered[i] === true) {

			var orbitPower = 0;
			var subtext = "";

			if(i <= starDataObject['orbits']['hot']) {
				orbitPower = starDataObject['power']['hot'];
				subtext = "hot orbit";
			} else if(i > parseInt(starDataObject['orbits']['hot']) && 
						i <= (parseInt(starDataObject['orbits']['hot']) + parseInt(starDataObject['orbits']['gold']))) {
				orbitPower = starDataObject['power']['gold'];
				subtext = "goldilocks orbit";
			} else {
				orbitPower = starDataObject['power']['cold'];
				subtext = "cold orbit";
			}
			$('#orbit_' + i + "_index").html(i);
			$('#orbit_' + i + "_power_produced_breakdown").html(orbitPower + powerPlusString + "<sub>&nbsp;" + subtext + "</sub>")
			$('#orbit_' + i).removeClass('unused');
		}
	}
	
	var totalZonesInOrbits = {};
	var zoneProduction = {};
	var brownedoutZonesInOrbits = {};
		
	// do zone production & consumption
	for(var zoneIndex in zonesDataObject) {
		var zone = zonesDataObject[zoneIndex];
		var world = zone['world'];
		var orbit = worldToOrbitTable[world];
		var brownedout = zone['brownout'];
		
		if(!totalZonesInOrbits[orbit]) {
			totalZonesInOrbits[orbit] = {};
			brownedoutZonesInOrbits[orbit] = {};
		}
		if(!totalZonesInOrbits[orbit][world]) {
			totalZonesInOrbits[orbit][world] = 0;
			brownedoutZonesInOrbits[orbit][world] = 0;
		}
		if(!brownedout) {
			totalZonesInOrbits[orbit][world]++;
		} else {
			brownedoutZonesInOrbits[orbit][world]++;
		}
		
		if(zone['production'].indexOf("(:power)") > 0) {
			var totalPower = String(zone['production']).split("(:power)")[0].trim();
			// this is a power zone
			var zonename = String(zoneIndex).split("#")[1];
			zonename = replaceAll(zonename, "_", " ");
			
			$('#orbit_' + orbit + "_power_produced_breakdown").append("<br>" + totalPower + powerPlusString + "<sub>&nbsp;<a href='/dokuwiki/" + zoneIndex+ "'>" + zonename + " on " + capString(String(world).split(":")[1]) + "</a></sub>");
		}
	}
	
	for(var orbitIndex in totalZonesInOrbits) {
		var first = "";
		for(var worldName in totalZonesInOrbits[orbitIndex]) {
			var numzones = totalZonesInOrbits[orbitIndex][worldName];
			var brownedout = "";
			if(brownedoutZonesInOrbits[orbit][world]) {
				brownedout = "(+" + brownedoutZonesInOrbits[orbit][world] + ")";
			}
			
			$('#orbit_' + orbitIndex + "_power_consumed_breakdown").append(first + numzones + "0" + powerMinString + "<sub>&nbsp;" + numzones + brownedout + " zones on <a href='/dokuwiki/" + worldName + "'>" + capString(worldName.split(":")[1]) + "</a></sub>");
			first = "<br>";
		}
	}
	
	if(systemHasBrownoutZones) {
		// run through zones
		for(var zoneIndex in zonesDataObject) {
			var zone = zonesDataObject[zoneIndex];
			var brownedout = zone['brownout'];
			if(brownedout) {
				var world = zone['world'];
				
				var worldImageString = world;
				// get image
				for(var worldIndex in worldsDataObject) {
					if(String(worldsDataObject[worldIndex]['link']).toLowerCase().trim() == String(world).toLowerCase().trim()) {
						worldImageString = worldsDataObject[worldIndex]['image'];
					}
				}
				var worldString = "<td><a href='/dokuwiki/" + world + "'><img src='/dokuwiki/_media/" + worldImageString + "?w=48&h=48'/></a></td>";
				
				var zoneid = zone['name'];
				var zoneString = "<td><a href='/dokuwiki/" + world + "#" + zoneid + "'>" + zoneid + "</a></td>";
				
				var type = zone['type'];
				var typeString = "<td>" + nameToWikiURLhref(String(type)) + "</td>";
				
				var prod = zone['production'];
				var prodString = "<td style='text-align:center'>" + fixIconHtml(prod) + "</td>";
				
				var prodbreak = zone['prodbreakdown'];
				var prodbreakString = "<td>" + fixIconHtml(bestEffortDoWikiStrings(String(prodbreak))) + "</td>";
				
				var upgrades = zone['upgrades'];
				var upgradesString = "<td>";
				for(var up in upgrades) {
					upgradesString += nameToWikiURLhref(upgrades[up]);
				}
				upgradesString += "</td>";

				var corp = zone['corp'];
				var corpString = "<td>" + nameToWikiURLhref(String(corp)) + "</td>";

				var special = zone['special'];
				var specialString = "<td>";
				for(var sp in special) {
					specialString += nameToWikiURLhref(special[sp]);
				}
				specialString += "</td>";
				
				$('#brownoutTable').append("<tr>" + worldString + zoneString + typeString + prodString + prodbreakString + upgradesString + corpString + specialString + "</td>");
				
			}
			
		}
		
		$('#brownedoutZonesblock').show();
	}

	
	// do population consumption
	for(var popIndex in populationsDataObject) {
		var population = populationsDataObject[popIndex];
		var race = String(population['race']);
		var world = String(population['world']);
				// special exception for IO
		if(race.toLowerCase().trim() == "ic:io") {
			var number = Math.ceil(String(population['number']) * 10)
		} else {
			var number = Math.floor(String(population['number']) * 10)
		}
		
		
		var orbit = worldToOrbitTable[world];
		var virtual = 1;
		if(virtualRaces[race]) {
			virtual = 2;
		}
		$('#orbit_' + orbit + "_power_consumed_breakdown").append("<br>" + (number * virtual) + powerMinString + "<sub>&nbsp;<a href='/dokuwiki/" + race + "'>" + capString(race.split(":")[1]) + "</a> on <a href='/dokuwiki/" + world + "'>" + capString(world.split(":")[1]) + "</sub>");
	}

	// now that we know all data, lets calculate the totals for each orbit

	
	// calculate current totals
	for(var orbit = 1; orbit < 11; orbit++) {
		var totalProduced = 0;
		var production = $('#orbit_' + orbit + "_power_produced_breakdown").html();
		var spl = production.split("<br>");
		for(var str in spl) {
			var num = parseInt(spl[str].split("<")[0]);
			if(!isNaN(num)) {
				totalProduced += num;
			}
		}

		var totalConsumed = 0;
		var consumption = $('#orbit_' + orbit + "_power_consumed_breakdown").html();
		spl = consumption.split("<br>");
		for(var str in spl) {
			var num = parseInt(spl[str].split("<")[0]);
			if(!isNaN(num)) {
				totalConsumed += num;
			}
		}

		if(!totalProduced == 0) {
			totalOrbitPower[orbit] = (totalProduced - totalConsumed);
		}
	}

	// based on current totals, we do power redistribution

	// sanity check: does the system even have enough power in general?
	var count = 0;
	for(var i = 1; i <= 10; i++) {
		if(!isNaN(totalOrbitPower[i])) {
			count += totalOrbitPower[i];
		}
	}
	if(count < 0) {
		// POWER SHORTAGE
		doPowerShortage();
	}
	
	if(!systemHasAShortage) {
	
		// if so, split orbits in orbits with power left over and orbits with power shortage
		var shortageOrbits = {};
		var leftoverOrbits = {};
		
		for(var i = 1; i <= 10; i++) {
			if(!isNaN(totalOrbitPower[i])) {
				if(totalOrbitPower[i] > 0) {
					leftoverOrbits[i] = totalOrbitPower[i];
				} else if (totalOrbitPower[i] < 0) {
					shortageOrbits[i] = -1 * totalOrbitPower[i];
				}
			}
		}
			
		if(numberOfLagrangePointStations > 0) {
			// has Lagrange point station(s), so use simple redistribution
			
			// distribute in order from orbits with power left over to orbits with power shortage
			for(var orbit in shortageOrbits) {
				var totalShortageInOrbit = shortageOrbits[orbit];
				for(var lo in leftoverOrbits) {
					if(!leftoverOrbits[lo]) {
						// orbit already emptied
						continue;
					}
					
					var totalLeftOver = leftoverOrbits[lo];
					
					if(totalShortageInOrbit > totalLeftOver) {
						// transfer and keep going

						$('#orbit_' + orbit + "_transfer_breakdown").append("<br>" + totalLeftOver + powerPlusString + "<sub>Transferred from orbit " + fixLargePlanetOrbits(doubleOrbitLargePlanets, lo) + "</sub>")
						$('#orbit_' + lo + "_transfer_breakdown").append("<br>" + totalLeftOver + powerMinString + "<sub>Transferred to orbit " + fixLargePlanetOrbits(doubleOrbitLargePlanets, orbit) + "</sub>")
						
						
						// remove from leftoverOrbits
						leftoverOrbits[lo] = false;
						totalShortageInOrbit = totalShortageInOrbit - totalLeftOver;


					} else if(totalShortageInOrbit == totalLeftOver) {
						// transfer and stop

						$('#orbit_' + orbit + "_transfer_breakdown").append("<br>" + totalShortageInOrbit + powerPlusString + "<sub>Transferred from orbit " + fixLargePlanetOrbits(doubleOrbitLargePlanets, lo) + "</sub>")
						$('#orbit_' + lo + "_transfer_breakdown").append("<br>" + totalShortageInOrbit + powerMinString + "<sub>Transferred to orbit " + fixLargePlanetOrbits(doubleOrbitLargePlanets, orbit) + "</sub>")

						// remove from leftoverOrbits
						leftoverOrbits[lo] = false;
						totalShortageInOrbit = 0;
						
						break;
					} else {
						// transfer only shortage and stop
						
						$('#orbit_' + orbit + "_transfer_breakdown").append("<br>" + totalShortageInOrbit + powerPlusString + "<sub>Transferred from orbit " + fixLargePlanetOrbits(doubleOrbitLargePlanets, lo) + "</sub>")
						$('#orbit_' + lo + "_transfer_breakdown").append("<br>" + totalShortageInOrbit + powerMinString + "<sub>Transferred to orbit " + fixLargePlanetOrbits(doubleOrbitLargePlanets, orbit) + "</sub>")
						
						// remove from leftoverOrbits
						leftoverOrbits[lo] = totalLeftOver - totalShortageInOrbit;
						totalShortageInOrbit = 0;
						
						// stop
						break;
					}
					
				}
				
			}
			
			
			// and put Lagrange point icon to show we know the system has it
			$('#powertitle').append("<div class='lagrangefloat'><a href='/dokuwiki/rules:lagrange_point_conduit_stations' title='Lagrange Point Conduit Stations'><img src='/dokuwiki/_media/rules:lagrange-point-conduit-stations.png?w=48&h=48' alt='Lagrange Point Conduit Stations' /></a></div>");
			
		} else {
			// no Lagrange point stations present, so use complex redistribution
			
			// initialise for later printing so we can avoid having transfers / energy cost when the system has brownouts
			var extraPowerUsages = {};
			var transfers = {};
			for(var i = 1; i <= 10; i++) {
				extraPowerUsages[i] = "";
				transfers[i] = "";
			}
			
			
			// run through all orbits with a shortage - should already be sorted low orbit index to high orbit index (otherwise the algorithm doesn't work)
			for(var orbit in shortageOrbits) {
				var totalShortageInOrbit = shortageOrbits[orbit];
				
				// run through all orbits with leftovers in order from left to right - should already be sorted this way (otherwise the algorithm doesn't work)
				for(var lo in leftoverOrbits) {
					if(!leftoverOrbits[lo]) {
						// orbit already emptied
						continue;
					}
					
					// get total in left over orbit
					var totalLeftOver = leftoverOrbits[lo];
					
					// calculate the orbit distance
					var distance = calculateOrbitDistance(totalOrbitPower, orbit, lo);
					// calculate the total power lost per power transferred
					var fraction = Math.pow(2, distance) 
					// calculate the maximum amount to arrive at the destination
					var maxToDest = Math.floor(totalLeftOver / fraction)
					
					// sanity check - if no power would arrive at the destination, skip this orbit
					if(maxToDest <= 0) {
						continue;
					}
					
					if(totalShortageInOrbit > maxToDest) {
						// transfer and keep going

						transfers[orbit] = transfers[orbit] + "<br>" + maxToDest + powerPlusString + "<sub>Transferred from orbit " + fixLargePlanetOrbits(doubleOrbitLargePlanets, lo) + "</sub>";
						transfers[lo] = transfers[lo] + "<br>" + maxToDest + powerMinString + "<sub>Transferred to orbit " + fixLargePlanetOrbits(doubleOrbitLargePlanets, orbit) + "</sub>";
						
						// don't forget to calculate extra power cost
						extraPowerUsages[lo] = extraPowerUsages[lo] + "<br>" + ((fraction * maxToDest) - maxToDest) + powerMinString + "<sub>Cost to transfer to orbit " + fixLargePlanetOrbits(doubleOrbitLargePlanets, orbit) + "</sub>";
						
						// remove from leftoverOrbits
						leftoverOrbits[lo] = totalLeftOver - (maxToDest * fraction);
						if(leftoverOrbits[lo] == 0) {
							leftoverOrbits[lo] = false;
						}
						totalShortageInOrbit = totalShortageInOrbit - maxToDest;
					} else if(totalShortageInOrbit == maxToDest) {
						// transfer and stop

						transfers[orbit] = transfers[orbit] + "<br>" + totalShortageInOrbit + powerPlusString + "<sub>Transferred from orbit " + fixLargePlanetOrbits(doubleOrbitLargePlanets, lo) + "</sub>";
						transfers[lo] = transfers[lo] + "<br>" + totalShortageInOrbit + powerMinString + "<sub>Transferred to orbit " + fixLargePlanetOrbits(doubleOrbitLargePlanets, orbit) + "</sub>";

						// don't forget to calculate extra power cost
						extraPowerUsages[lo] = extraPowerUsages[lo] + "<br>" + ((fraction * totalShortageInOrbit) - totalShortageInOrbit) + powerMinString + "<sub>Cost to transfer to orbit " + fixLargePlanetOrbits(doubleOrbitLargePlanets, orbit) + "</sub>";

						// remove from leftoverOrbits
						leftoverOrbits[lo] = totalLeftOver - (maxToDest * fraction);
						if(leftoverOrbits[lo] == 0) {
							leftoverOrbits[lo] = false;
						}
						totalShortageInOrbit = 0;
						
						break;
					} else {
						// transfer only shortage and stop
						
						transfers[orbit] = transfers[orbit] + "<br>" + totalShortageInOrbit + powerPlusString + "<sub>Transferred from orbit " + fixLargePlanetOrbits(doubleOrbitLargePlanets, lo) + "</sub>";
						transfers[lo] = transfers[lo] + "<br>" + totalShortageInOrbit + powerMinString + "<sub>Transferred to orbit " + fixLargePlanetOrbits(doubleOrbitLargePlanets, orbit) + "</sub>";
						
						// don't forget to calculate extra power cost
						extraPowerUsages[lo] = extraPowerUsages[lo] + "<br>" + ((fraction * totalShortageInOrbit) - totalShortageInOrbit) + powerMinString + "<sub>Cost to transfer to orbit " + fixLargePlanetOrbits(doubleOrbitLargePlanets, orbit) + "</sub>";

						
						// remove from leftoverOrbits
						leftoverOrbits[lo] = totalLeftOver - (totalShortageInOrbit * fraction);
						if(leftoverOrbits[lo] == 0) {
							leftoverOrbits[lo] = false;
						}
						totalShortageInOrbit = 0;
						
						// stop
						break;
					}
				}
				// still a shortage left after all transfers have been completed?
				if(totalShortageInOrbit > 0) {
					doPowerShortage();
					
				}
				
			}
			// no power shortage, so write transfers down
			if(!systemHasAShortage) {
				for(var i = 1; i <= 10; i++) {
					
					// get transfers
					var transferString = transfers[i];
					// remove starting <br>
					transferString = transferString.substring(4);
					$('#orbit_' + i + "_transfer_breakdown").append(transferString);
					
					// get extra power cost
					var pString = extraPowerUsages[i];
					// iff no current power usage, then trim the string's leading <br>
					if(String($('#orbit_' + i + "_power_consumed_breakdown").html()).trim() == "") {
						pString = pString.substring(4);
					}
					$('#orbit_' + i + "_power_consumed_breakdown").append(pString);
					
				}
				
				// add warning regarding distribution (only if no shortage)
				$('#surplustitle').append("*");
				$('#tablemount').append("<sub>* Warning: potential surplus may be higher than listed due to sub-optimal transfers</sub>");
			}

		}
		
		// actually display totals, now that redistribution has been completed
		
		var sumTotal = 0;
		var sumProd = 0;
		var sumCons = 0;
		var sumTrans = 0;
		
		for(var orbit = 1; orbit < 11; orbit++) {
			var totalProduced = 0;
			var production = $('#orbit_' + orbit + "_power_produced_breakdown").html();
			var spl = production.split("<br>");
			for(var str in spl) {
				var num = parseInt(spl[str].split("<")[0]);
				if(!isNaN(num)) {
					totalProduced += num;
				}
			}
			$('#orbit_' + orbit + "_power_produced").html(totalProduced + powerPlusString);

			var totalConsumed = 0;
			var consumption = $('#orbit_' + orbit + "_power_consumed_breakdown").html();
			spl = consumption.split("<br>");
			for(var str in spl) {
				var num = parseInt(spl[str].split("<")[0]);
				if(!isNaN(num)) {
					totalConsumed += num;
				}
			}
			$('#orbit_' + orbit + "_power_consumed").html(totalConsumed + powerMinString);
			
			var totalTransferred = 0;
			if(!systemHasAShortage) {
				var transferred = $('#orbit_' + orbit + "_transfer_breakdown").html();
				var incoming = true;
				spl = transferred.split("<br>");
				for(var str in spl) {
					var num = parseInt(spl[str].split("<")[0]);
					if(!isNaN(num)) {
						// determine if its plus or minus
						var temp = spl[str].split("Power, ");
						if(temp[1].startsWith("O")) {
							// outgoing power
							incoming = false;
						}
						totalTransferred += num;
					}
				}

				if(!isNaN(totalTransferred)) {
					if(incoming) {
						// incoming so orbits gains
						$('#orbit_' + orbit + "_transfer").html(totalTransferred + powerPlusString);
						sumTrans += totalTransferred;
					} else {
						// outgoing so orbit loses
						$('#orbit_' + orbit + "_transfer").html(totalTransferred + powerMinString);
						totalTransferred = totalTransferred * -1;
					}
				} else {
					totalTransferred = 0;
				}
			}

			if((totalProduced + totalTransferred - totalConsumed) >= 0) {
				$('#orbit_' + orbit + "_surplus").html((totalProduced + totalTransferred - totalConsumed) + powerPlusString);
			} else {
				$('#orbit_' + orbit + "_surplus").html((totalProduced + totalTransferred - totalConsumed) + powerMinString);
			}

			if(!isNaN(totalProduced)) {
				sumTotal += totalProduced;
				sumProd += totalProduced;
			}
			if(!isNaN(totalConsumed)) {
				sumTotal -= totalConsumed;
				sumCons += totalConsumed;
			}
		}

		$('#totprod').html(sumProd + powerPlusString);
		$('#totcons').html(sumCons + powerMinString);
		if(!systemHasAShortage) {
			$('#tottrans').html(sumTrans + powerString);
		}
		if(numberOfLagrangePointStations > 0 || !systemHasAShortage) {
			if(sumTotal >= 0) {
				$('#balance').html(sumTotal + powerPlusString);
			} else {
				$('#balance').html((-1 * sumTotal) + powerMinString);
			}
		}

	}
		
	
	
}
/*
	<td id="orbit_1_index"></td>
	<td id="orbit_1_worlds"></td>
	<td id="orbit_1_power_produced"></td>
	<td id="orbit_1_power_produced_breakdown"></td>
	<td id="orbit_1_power_consumed"></td>
	<td id="orbit_1_power_consumed_breakdown"></td>

*/

// Fix orbit names for worlds with a large planet using double orbits

function fixLargePlanetOrbits(orbitData, orbit) {
	if(orbitData[orbit]) {
		return orbitData[orbit];
	}
	return orbit;
}

// Power Shortage
function doPowerShortage() {
	$('#brownoutmarker').removeClass("unused");
	$('#powerblock').addClass("brownout");
	systemHasAShortage = true;
}

// Replace all function doesn't exist in javascript String prototype o_O
function replaceAll(source,stringToFind,stringToReplace){
	var temp = String(source);
	var index = temp.indexOf(stringToFind);
	while(index != -1){
		temp = temp.replace(stringToFind,stringToReplace);
		index = temp.indexOf(stringToFind);
	}
	return temp;
}

// capitalize the first letter of every word in the string string
function capString(string) {
	return string.replace(/(?:^|\s)\S/g, function(a) { return a.toUpperCase(); });
}

// Turn namespace + name into <a> link
function nameToWikiURLhref(string) {
	var name = string.split(":")[1];
	name = replaceAll(name, "_", " ");
	name = capString(name);
	
	return "<a href='/dokuwiki/" + string + "'>" + name + "</a>";
}

// calculate the transfer distance between two orbits, taking such annoying things as non-heavy large planets into account
function calculateOrbitDistance(totalOrbitPower, orbit, lo) {

	// swap is orbit > lo, so lo is always greater than orbit
	if(orbit > lo) {
		var temp = orbit;
		orbit = lo;
		lo = temp;
	}
	
	var distance = 0;
	
	for(var i = orbit; i < lo; i++) {
		if(!isNaN(totalOrbitPower[i])) {
			distance++;
		}
	}

	return distance;
}

/**
 * Fixes HTML icons
 */
function fixIconHtml(str) {
	str = String(str);

	str = str.replace(/:dot10:/g, "&#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;&#9679;&#9679;");
	str = str.replace(/:dot11:/g, "&#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;&#9679;&#9679; &#9679;");
	str = str.replace(/:dot12:/g, "&#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;");
	str = str.replace(/:dot13:/g, "&#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;");
	str = str.replace(/:dot14:/g, "&#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;&#9679;");
	str = str.replace(/:dot15:/g, "&#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;&#9679;&#9679;");
	str = str.replace(/:dot16:/g, "&#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;&#9679;&#9679; &#9679;");
	str = str.replace(/:dot17:/g, "&#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;");
	str = str.replace(/:dot18:/g, "&#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;");
	str = str.replace(/:dot19:/g, "&#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;&#9679;");
	str = str.replace(/:dot20:/g, "&#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;&#9679;&#9679;");
	str = str.replace(/:dot0:/g, "&#9675;");
	str = str.replace(/:dot1:/g, "&#9679;");
	str = str.replace(/:dot2:/g, "&#9679;&#9679;");
	str = str.replace(/:dot3:/g, "&#9679;&#9679;&#9679;");
	str = str.replace(/:dot4:/g, "&#9679;&#9679;&#9679;&#9679;");
	str = str.replace(/:dot5:/g, "&#9679;&#9679;&#9679;&#9679;&#9679;");
	str = str.replace(/:dot6:/g, "&#9679;&#9679;&#9679;&#9679;&#9679; &#9679;");
	str = str.replace(/:dot7:/g, "&#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;");
	str = str.replace(/:dot8:/g, "&#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;");
	str = str.replace(/:dot9:/g, "&#9679;&#9679;&#9679;&#9679;&#9679; &#9679;&#9679;&#9679;&#9679;");
	return fwurg.icons.render(str);
}

function bestEffortDoWikiStrings(text) {
	while(text.indexOf("[[") >= 0 && text.indexOf("]]") >=0 && text.indexOf("]]") > text.indexOf("[[")) {
		var before = text.substring(0, text.indexOf("[["));
		var after = text.substring(text.indexOf("]]") + 2);
		
		var between = text.substring(text.indexOf("[[") + 2, text.indexOf("]]"));
		if(between.indexOf("|") >= 0) {
			var link = between.substring(0, between.indexOf("|"));
			var alt = between.substring(between.indexOf("|") + 1);
			text = before + bestEffortWikiLink(link, alt) + after;
		} else {
			text = before + bestEffortWikiLink(between) + after;
		}
	}

	return fixIconHtml(text);
}

/**
 * Do a best effort parsing of the wiki link to human readable format as a link. 
 * altText is an optional variable.
 */
function bestEffortWikiLink(link, altText) {
	var replaced = "";

	if(!altText) {

		replaced = link;

		if(replaced.indexOf("#") >= 0) {
			if(replaced.indexOf("#") < replaced.length - 1) {
				replaced = replaced.substring(replaced.indexOf("#") + 1);
			} else {
				replaced = replaced.substring(0, replaced.indexOf("#"));
			}
		}

		while(replaced.indexOf(":") >= 0) {
			replaced = replaced.substring(replaced.indexOf(":") + 1);
		}

		while(replaced.indexOf("_") >= 0) {
			var num = replaced.indexOf("_");
			replaced = replaced.substring(0, num) 
					+ " " 
					+ replaced.substring(num + 1, num + 2).toUpperCase()
					+ replaced.substring(num + 2);
		}

		replaced = replaced.substring(0, 1).toUpperCase() + replaced.substring(1);	
	} else {
		replaced = altText;
	}

	var str = "<a href='/dokuwiki/" + link + "'>" + replaced + "</a>"
	return str;
}
