// This file contains the Character details

// Create a new character
var jedi = new Character();

/**
 * This function handles the insertion of the image after being selected in the wiki tab - it cleans up the selected name to be in the proper format, sets the value for the data model of this builder and updates the image.
 * 
 * @param varA is always "wiki__text"
 * @param varB is the start of the image tag (including {{: as a start and | as an end
 * @param varC is }}
 * @param varD is an empty string
 */
var insertTags = function(varA, varB, varC, varD) {
	$('#imageFieldEntry').val(varB.substring(3,varB.indexOf("?")));
	jedi.setImage($('#imageFieldEntry').val());
	loadCharImage($('#imageFieldEntry').val());
}

/**
 * Load the Character Image when an entry is typed so you can see immidiately if you typed correctly. This method is called onChange of the image field.
 * 
 * @param image the image to load (as entered into the wiki)
 */
function loadCharImage(image) {
	$('#characterImage').attr("src", "/dokuwiki/_media/" + image);
}
/**
 * Race - represents a race
 *
 * @param raceName the name of the race
 * @param raceImage the image of the race as listed on the wiki
 * @param raceChars the racial characteristics as an array
 * @param raceUrl the pagename of the race
 * @param raceDescription the description of the race
 */
function Race(raceName, raceImage, raceChars, raceUrl, raceDescription) {
	// race name
	this.name = raceName;
	
	/**
	 * Get the name of the race.
	 *
	 * @return the name of the race
	 */
	this.getName = function() {
		return this.name;
	}
	
	// image
	this.image = raceImage;
	
	/**
	 * Get the image of the race as listed on the wiki.
	 *
	 * @return the image of the race
	 */
	this.getImage = function() {
		return this.image;
	}
	
	// characteristics
	this.racialCharacteristics = raceChars;
	
	/**
	 * Get an array of the racial characteristics  of the race.
	 *
	 * @return the racial characteristics of the race
	 */
	this.getRacialChars = function() {
		return this.racialCharacteristics;
	}
	
	/**
	 * Get the racial characteristic at index index - not sorted, but constant
	 *
	 * @param index the index of the racial characteristic
	 * @return the index-th racial characteristic of the race
	 */
	this.getRacialChar = function(index) {
		return this.racialCharacteristics[index];
	}

	// race page id
	this.url = raceUrl;

	/**
	 * Get the page id of the race.
	 *
	 * @return the page id of the race
	 */
	this.getUrl = function() {
		return this.url;
	}

	// race description
	this.description = raceDescription;

	/**
	 * Get the description of the race.
     *
     * @return the description of the race
     */
	this.getDescription = function() {
		return this.description;
	}

	
}

/**
 * Character Constructor.
 */
function Character() {

	// name of the character
	this.name;
	this.setName = function(newName) {
		this.name = newName.replace(/^\s\s*/, '').replace(/\s\s*$/, '');
	}
	this.getName = function() {
		return this.name;
	}
	
	// titles of the character
	this.titles;
	this.setTitles = function(newTitles) {
		this.titles = newTitles.replace(/^\s\s*/, '').replace(/\s\s*$/, '');
	}
	this.getTitles = function() {
		return this.titles;
	}

	// age of the character
	this.age;
	this.setAge = function(newAge) {
		this.age = newAge.replace(/^\s\s*/, '').replace(/\s\s*$/, '');
	}
	this.getAge = function() {
		return this.age;
	}

	// image of the character
	this.image = "ic:default-character.png";
	this.setImage = function(newImage) {
		this.image = newImage.replace(/^\s\s*/, '').replace(/\s\s*$/, '');
	}
	this.getImage = function() {
		return this.image;
	}
	
	// race of the character
	this.species;
	this.setSpecies = function(newSpecies) {
		this.species = newSpecies.replace(/^\s\s*/, '').replace(/\s\s*$/, '');
	}
	this.getSpecies = function() {
		return this.species;
	}
	
	// gender pronoun used for the character
	this.genderpronoun;
	this.setGenderPronoun = function(newGenderPronoun) {
		this.genderpronoun = newGenderPronoun.replace(/^\s\s*/, '').replace(/\s\s*$/, '');
	}
	this.getGenderPronoun = function() {
		return this.genderpronoun;
	}
	
	// faction
	this.affiliations;
	this.setAffiliation = function(newAffiliation) {
		this.affiliation = newAffiliation.replace(/^\s\s*/, '').replace(/\s\s*$/, '');
	}
	this.getAffiliation = function() {
		return this.affiliation;
	}
	
	// player of the character
	this.user;
	this.setUser = function(newUser) {
		this.user = newUser.replace(/^\s\s*/, '').replace(/\s\s*$/, '');
	}
	this.getUser = function() {
		return this.user;
	}
	
	// role of the character
	this.role;
	this.setRole = function(newRole) {
		this.role = newRole.replace(/^\s\s*/, '').replace(/\s\s*$/, '');
	}
	this.getRole = function() {
		return this.role;
	}

	// the force level of the jedi
	this.forcelevel = 4;
	
	/**
	 * Get the force level.
	 * @return the force level of this jedi
	 */
	this.getForceLevel = function() {
		return this.forcelevel;
	}
	
	/**
	 * Set the force level.
	 * @param num the new level to set (may not be negative)
	 */
	this.setForceLevel = function(num) {
		this.forcelevel = num;
		if(num <= 0) {
			this.forcerank = "Force Sensitive";
		} else if(num <= 3) {
			this.forcerank = "Initiate";
		} else if(num <= 6) {
			this.forcerank = "Padawan";
		} else if(num <= 9) {
			this.forcerank = "Knight";
		} else {
			this.forcerank = "Master";
		}
	}
	
	// the associated rank
	this.forcerank = "Padawan";
	
	/**
	 * Get the Force Rank of the jedi.
	 * @return the force rank
	 */
	this.getForceRank = function() {
		return this.forcerank;
	}
	
	// the jedi's fitness attribute (Control Body)
	this.fitness = 3;
	
	// the jedi's vision attribute (Sense Body)
	this.vision = 3;
	
	// the jedi's strength attribute (Alter Body)
	this.strength = 3;
	
	// the jedi's reason attribute (Control Mind)
	this.reason = 3;

	// the jedi's intuition attribute (Sense Mind)
	this.intuition = 3;
	
	// the jedi's energy attribute (Alter Mind)
	this.energy = 3;

	
	/**
	 * Get the value of a specified attribute (only works for the legal 6: Fitness, Vision, Strength, Reason, Intuition and Energy)
	 *
	 * @param attribute the attribute to get the value for
	 * @return the value of that attribute or nothing if an illegal attribute is specified
	 */
	this.getAttribute = function(attribute) {
		if(attribute == 'Fitness') {
			return this.fitness;
		} else if(attribute == 'Vision') {
			return this.vision;
		} else if(attribute == 'Strength') {
			return this.strength;
		} else if(attribute == 'Reason') {
			return this.reason;
		} else if(attribute == 'Intuition') {
			return this.intuition;
		} else if(attribute == 'Energy') {
			return this.energy;
		}
	}
	
	this.setAttribute = function(attribute, value) {
		if(attribute == 'Fitness') {
			this.fitness = value;
		} else if(attribute == 'Vision') {
			this.vision = value;
		} else if(attribute == 'Strength') {
			this.strength = value;
		} else if(attribute == 'Reason') {
			this.reason = value;
		} else if(attribute == 'Intuition') {
			this.intuition = value;
		} else if(attribute == 'Energy') {
			this.energy = value;
		}
	}
	
	// array of the Jedi's Force Powers mapped to numbers (level)
	this.forcepowers = new Array();
	
	this.getForcePowerLevel = function(forcepower) {
		if(this.forcepowers[forcepower]) {
			return this.forcepowers[forcepower];
		} else {
			return 0;
		}
	}
	
	this.setForcePowerLevel = function(forcepower, level) {
		this.forcepowers[forcepower] = level;
	}
	
	this.getForcePowers = function() {
		return this.forcepowers;
	}

	
	// array of the Jedi's skills, mapped to numbers (level)
	this.skills = new Array();
	
	this.getSkillLevel = function(skill) {
		skill = $.trim(skill);
		if(this.skills[skill]) {
			return this.skills[skill];
		} else {
			return 0;
		}
	}
	
	this.setSkillLevel = function(skill, level) {
		skill = $.trim(skill);
		this.skills[skill] = level;
	}

	this.getSkills = function() {
		return this.skills;
	}
		
	// array of combat styles mapped to list of special manoeuvres
	this.combatstyles = new Array();
	
	this.toggleStyle = function(styleName) {
		if(this.hasStyle(styleName)) {
			this.combatstyles[styleName] = false;
		} else {
			this.combatstyles[styleName] = new Array();
		}
	}
	
	this.hasStyle = function(styleName) {
		return this.combatstyles[styleName];
	}
	
	this.toggleManoeuvre = function(styleName, manoeuvreName) {
		// sanity check
		if(this.hasStyle(styleName)) {
			if(this.hasManoeuvre(styleName, manoeuvreName)) {
				this.combatstyles[styleName][manoeuvreName] = false;
			} else {
				this.combatstyles[styleName][manoeuvreName] = true;
			}
		}
	}
	
	this.hasManoeuvre = function(styleName, manoeuvreName) {
		if(this.hasStyle(styleName)) {
			return this.combatstyles[styleName][manoeuvreName];
		} else {
			return false;
		}		
	}
	
	// the jedi's race
	this.race;

	this.setRace = function(newRace) {
		this.race = newRace;
	}

	this.getRace = function() {
		return this.race;
	}

	this.toWikiString = function() {
	     var text = "====== " + this.getName() + " ======\n\n";
		
		text += "<data !wip #wip>\n";
		text += "User [ref::user] : " + this.getUser() + "\n";
		text += "Description [wiki] : Page generated using the [[https://www.fwurg.net/tools/character-builder/char.php|Character Builder]]\n";
		text += "Page [ref] : [[]]\n";
		text += "</data>\n\n";

		if(this.getRole() == "Jedi") {
			text += "<data !unvalidated #unvalidated>\n";
			text += "User [ref::user] : " + this.getUser() + "\n";
			text += "Description [wiki]   : New Jedi require approval from a [[rules:storyteller]]. You can ask them for approval on the [[https://www.fwurg.net/phpbb/viewforum.php?f=9|forum]]\n";
			text += "Page [ref] : [[]]\n";
			text += "</data>\n\n";
		}
		 
		text += "<data !character>\n";
		text += "Full Name                : " + this.getName() + "\n";
		text += "Description [wiki]         : ";
			if(this.getRole() != "-") {
				if(this.getRole() != "Jedi") {
					text += this.getRole();
				} else {
					text += "Jedi " + this.getForceRank();
				}
				if(this.getAffiliation()) {
					text += " of " + this.getAffiliation()
				}
			}
		text += "\n";
		text += "Image [image::300]         : " + this.getImage() + "\n";
		text += "Titles*                    : " + (this.getTitles() ? this.getTitles() : "") + "\n";
		text += "Species [ref]              : " + this.getRace() + "\n";
		text += "Preferred gender pronoun   : " + this.getGenderPronoun() + "\n";
		text += "Age                        : " + (this.getAge() ? this.getAge() : "") + "\n";
		text += "Affiliations [ref]*        : " + (this.getAffiliation() ? (this.getAffiliation() + ", ") : "");
			if(this.getRole() == "Jedi") {
				text += "Jedi Council, ";
			}			
			text += "Union\n";
		text += "User [ref::user]           : " + this.getUser() + "\n";
		text += "Type [rule]                : PC\n";
		text += "Roles*                     : " + this.getRole() + "\n";
		text += "</data>\n\n";

		text += "YOUR DESCRIPTION HERE!\n";

		if(this.getRole() == "Jedi") {

			text += "===== Attributes =====\n\n";
			text += "<data !jedi>\n";
			text += "Force Level [dot::t10g5]  : " + this.getForceLevel() + "\n";
			text += "Rank                      : " + this.getForceRank() + "\n";
			text += "Fitness [dot]             : " + this.getAttribute('Fitness') + "\n";
			text += "Vision [dot]              : " + this.getAttribute('Vision') + "\n";
			text += "Strength [dot]            : " + this.getAttribute('Strength') + "\n";
			text += "Reason [dot]              : " + this.getAttribute('Reason') + "\n";
			text += "Intuition [dot]           : " + this.getAttribute('Intuition') + "\n";
			text += "Energy [dot]              : " + this.getAttribute('Energy') + "\n";
			text += "</data>\n\n";
			
			var localSkills = this.getSkills();		
			var first = true;
			for(var skillIndex in localSkills) {
				if(localSkills[skillIndex] > 0) {
					if(first) {
						text += "===== Skills =====\n\n";
						first = false;
					}
					text += "<data !skill_known #" + skillIndex + ">\n";
					text += "Character [ref] : [[]]\n";
					text += "Skill [rule]    : " + skillIndex + " Skill\n";
					text += "Level           : " + localSkills[skillIndex] + "\n"
					text += "</data>\n\n";
				}

			}

			var localPowers = this.getForcePowers();		
			first = true;
			for(var powerIndex in localPowers) {
				if(localPowers[powerIndex] > 0) {
					if(first) {
						text += "===== Force Powers =====\n\n";
						first = false;
					}
					text += "<data !force_power_known #" + powerIndex + ">\n";
					text += "Character [ref]    : [[]]\n";
					text += "Force Power [rule] : " + powerIndex + "\n";
					text += "Level              : " + localPowers[powerIndex] + "\n"
					text += "</data>\n\n";
				}

			}
			
			text += "===== Combat Styles =====\n\n";

			for(var styleIndex in this.combatstyles) {
				if(this.combatstyles[styleIndex]) {
					text += "<data !combat_style_known #" + styleIndex + ">\n";
					text += "Character [ref]     : [[]]\n";
					text += "Combat Style [rule] : " + styleIndex + "\n";
					text += "Combat Style Manoeuvres [rule]: ";
			        var first_manoevre = true;	
					for(var manoeuvreIndex in this.combatstyles[styleIndex]) {
						if(this.combatstyles[styleIndex][manoeuvreIndex]) {
                            if(!first_manoeuvre) text+=', ';
							text += styleIndex+'#'+manoeuvreIndex + " ";
                            first_manoeuvre = false;
						}
					}
					text += "\n";
					text += "</data>\n\n";
				}

			}
			
			// hax to add non-combat style
			text += "<data !combat_style_known #Trained Combatant Style>\n";
			text += "Character [ref]     : [[]]\n";
			text += "Combat Style [rule] : Trained Combatant Style\n";
			text += "</data>\n\n";

			text += "===== Lightsabers =====\n\n";
			
			text += saber.toWikiString();
			
			text += "\n\n===== Character Progression =====\n\n";
		}

		return text;
	}

}

function addRace(race) {
	// Do not display races without an image (Kiitik are missing image and are outdated and without an image the display looks silly anyway)
	if(race.getImage()) {

		var html = '';
		html += '<div class=\'select\' onClick="jedi.setRace(\'' + race.getName().replace('\'', '\\\'') + '\');">';
		html += '<div class="selectimage"><img class="selectimage" src="/dokuwiki/_media/' + race.getImage() + '?w=64" /></div>'
		html += '<table class=\'tinytable\'>';
		html += '<tr style="display:block;"><th style="display:block;padding-left:2px;"><a target="_blank" href="/dokuwiki/' ;
		html += race.getUrl();
		html += '" title="';
		html += race.getDescription();
		html += '">';
		html += race.getName();
		html += '</a></th></tr><tr style="display:block;"><td style="display:block;">';
		html += race.getRacialChar(0);
		html += '</td></tr><tr style="display:block;"><td style="display:block;">'
		html += race.getRacialChar(1);
		html += '</td></tr><tr style="display:block;"><td style="display:block;">'
		html += race.getRacialChar(2);
		if(race.getRacialChar(3)) {
			html += '</td></tr><tr style="display:block;"><td style="display:block;">'
			html += race.getRacialChar(3);
		}
		html += '</td></tr></table></div>'

		$('#races').append(html);
	}
	
	// TODO: consequences for Jedi Building
	
}

$(function() {
	var wiki = new fwurg.Wiki();
	var qb = wiki.qb();

	// get the table with name, image, characteristics per race
	// this requires that a race has an image (this is in acc-
	// ordance with comments in the orignal source)
	wiki.queryRelations(qb.query(
		qb.fields(
			'?r',
			'?rt@unique',
			'?image@unique',
			'?characteristics',
			'?description'
		),
		qb.where(
			'?r is a: race',
			'?r entry title: ?rt',
			'?r Image[image]: ?image',
			'?r Racial Characteristics[rule]: ?rc',
			'?r Description[wiki]: ?description',
			'?rc entry title: ?characteristics',
			'minus {',
			'  ?w is a: wip',
			'  ?w Page[ref]: ?r',
			'}',
			'minus {',
			'  ?u is a: unvalidated',
			'  ?u Page[ref]: ?r',
			'}'

		),
		qb.group(
			'?r',
			'?description'
		)
	)).then(function(data) {
		var races = data.body;
		var sortedRaces = new Array();
		for(var k in races) {
			sortedRaces[k] = races[k][1][0];
		}
		sortedRaces.sort();
		for(var k in sortedRaces) {
			addRace(new Race(sortedRaces[k], races[k][2][0], races[k][3], races[k][0], races[k][4][0]));
		}
		$('#races .select').click(function() {
			$(this).addClass("selected").siblings().removeClass("selected");
		}).filter(':first').click();
	});
	
	$('#charRole .select').click(function() {
		$(this).addClass("selected").siblings().removeClass("selected");
	}).filter(':first').click();
	$('#genderPronoun .select').click(function() {
		$(this).addClass("selected").siblings().removeClass("selected");
	}).filter(':first').click();

})

function replaceAll(Source,stringToFind,stringToReplace){
	var temp = Source;
	var index = temp.indexOf(stringToFind);
	while(index != -1){
		temp = temp.replace(stringToFind,stringToReplace);
		index = temp.indexOf(stringToFind);
	}
	return temp;
}

function createCharacterAccount() {
	// sanity check
	if(!jedi.getName() || jedi.getName().length <= 0) {
		alert("You have not yet chosen a character name.");
		return;
	}

	if(!jedi.getImage() || jedi.getImage().length <= 0) {
		alert("No character image has been selected.");
		return;
	}	

    var form = document.createElement("form");
    form.setAttribute("method", "post");
    form.setAttribute("action", "/tools/character-builder/create.php");

// masterAccount from userEntry field
    var masterAccount = document.createElement("input");
    masterAccount.setAttribute("type", "hidden");
    masterAccount.setAttribute("name", "masterAccount");
    masterAccount.setAttribute("value", jedi.getUser());
    form.appendChild(masterAccount);

// charname from jedi.getName()
// if the character is a senator, the account name will be prepended by 'Senator '

    var charname = document.createElement("input");
    charname.setAttribute("type", "hidden");
    charname.setAttribute("name", "charname");
    if(jedi.getRole() == "Senator") {
	charname.setAttribute("value", "Senator " + jedi.getName());
    } else {
    	charname.setAttribute("value", jedi.getName());
    }
    form.appendChild(charname);

// image from jedi.getImage()
// if the character is a senator use the representative image
// else use the forum image

// BUT: for now just use /dokuwiki/_media/ as base
    var image = document.createElement("input");
    image.setAttribute("type", "hidden");
    image.setAttribute("name", "image");
    image.setAttribute("value", "/dokuwiki/_media/" + jedi.getImage());
    form.appendChild(image);

// wikiurl from jedi.getName()
// link to the wiki page url (based on character name)
    var wikiurl = document.createElement("input");
    wikiurl.setAttribute("type", "hidden");
    wikiurl.setAttribute("name", "wikiurl");
    wikiurl.setAttribute("value", "/dokuwiki/ic:" + jedi.getName().replace(":", "_").replace(";", "_"));
    form.appendChild(wikiurl);

    var wikitext = document.createElement("textarea");
    wikitext.setAttribute("name", "wikitext");
    wikitext.setAttribute("style", "display:none;");
    $(wikitext).text(jedi.toWikiString());
    form.appendChild(wikitext);

    document.body.appendChild(form);
    form.submit();
}

