(function($) {

/**
 * Disables the widget. Multiplexes to all widgets with this id.
 */
var disableWidget = function($widget) {
    var topic = $widget.attr('data-thread');
    var $widgets = $('.followWidget[data-thread='+topic+']');

    $widgets.each(function(_,widget) {
        var $widget = $(widget);
        $widget.toggleClass('disabled',true);
    
        if($widget.hasClass('disabled')) {
            $widget.poshytip('hide');
        }
    });
}

/**
 * Updates the widget's state. Multiplexes to all widgets with this id.
 */
var updateWidget = function($widget, state) {
    var following = state.follows !== false;

    var topic = $widget.attr('data-thread');
    var $widgets = $('.followWidget[data-thread='+topic+']');

    $widgets.each(function(_,widget) {
      var $widget = $(widget);

        // clear out widget state
        $widget.attr('class','followWidget disabled');

        // set classes depending on state
        if(following) {
            $widget.addClass('followed').addClass('followed-'+state.follows);
            $widget.attr('title','You are following this thread. Click to change.');
        } else {
            $widget.addClass('unfollowed');
            $widget.attr('title','You do not follow this thread. Click to follow.');
        }

        // enable the widget
        $widget.toggleClass('disabled', false);
    });
}

/**
 * Performs a request to the backend, followed by an update of the widget.
 */
var requestThenUpdate = function($widget, params) {
    // disable the widget
    disableWidget($widget);

    // do the request
    return $.get('/tools/followed/update',
        params,
        function(reply) { updateWidget($widget,reply); },
        'json'
    );
}

var net = {
    /**
     * Follows a topic, with a certain type.
     */
    follow: function($widget, type) {
        requestThenUpdate($widget, {
            op:'follow',
            thread:$widget.attr('data-thread'),
            type: type
        });
    },
    
    /**
     * Unfollows a topic.
     */
    unfollow: function($widget) {
        requestThenUpdate($widget,{
            op:'unfollow',
            thread:$widget.attr('data-thread')
        });
    },
    
    /**
     * Refreshes the widget with data from the backend.
     */
    update: function($widget) {
        requestThenUpdate($widget,{
            op: 'status',
            thread:$widget.attr('data-thread')
        });
    }
}

var types = [
    {img:'/images/followed-blue.png', call:function($w){net.follow($w,'blue');}, title:'Frozen: Stashed away for future refercing.' },
    {img:'/images/unfollowed.png', call:function($w){net.unfollow($w);}, title:'Unfollow' },
    {img:'/images/followed-green.png', call:function($w){net.follow($w,'green');}, title:'Up to Date!' },
    {img:'/images/followed-red.png', call:function($w){net.follow($w,'red');}, title:'Needs post!' },
    {img:'/images/followed-yellow.png', call:function($w){net.follow($w,'yellow');}, title:'Todo' },
];

// initialize follow widgets
$(document).ready(function() {
    // keeps a list of topic IDs already initialized
    var seen = {};

    $('.followWidget').each(function(_,widget) {
        // the widget
        var $widget = $(widget);

        // create the necessary elements
        $widget.append('<div class="status"></div><div class="invitations"></div>');

        var $popup = $('<div class="followPopup"></div>');

        $(types).each(function(_,type) {
            $popup.append('<img class="statusSelector" src="'+type.img+'" title="'+type.title+'"/>');
            $popup.find('img.statusSelector').last().click(function() {
                type.call($widget);
            });
        });

        $widget.poshytip({
            className: 'tip-quickselect',
            alignTo: 'target',
            alignX: 'inner-right',
            offsetX: 0,
            offsetY: -26,
            content: $popup,
            fade: true,
            slide:false,
            showTimeout: 1000*60*60
        });

        // skip already seen ids
        if($widget.attr('data-thread') in seen) return;
        seen[$widget.attr('data-thread')] = true;

        if($widget.attr('data-status')) {
            // Local status present to initialize with
            updateWidget($widget, {follows: $widget.attr('data-status')});
        } else {
            // No local status to initialize with, fetch status from server
            net.update($widget);
        }
    });

    $('.followWidget .status').click(function() {
        var $widget = $(this).closest('.followWidget');

        // prevent action when disabled
        if($widget.hasClass('disabled')) return;

        $widget.poshytip('show');
    });
});

})(jQuery);
