(function(fwurg) {

/**
 * Data for each single icon overlay.
 */
var	data = {
"special-points": {image:'special.png',title:'Special point', aliases:['special-point']},
"gas-mass": {image:'mass-gas.png',title:'Gas mass', aliases:[]},
"rock-mass": {image:'mass-rock.png',title:'Rock mass', aliases:[]},
"bio-mass": {image:'mass-bio.png',title:'Bio mass', aliases:[]},
"cold-orbit": {image:'orbit-cold.png',title:'Cold Orbit', aliases:[]},
"goldilocks-orbit": {image:'orbit-gold.png',title:'Goldilocks Orbit', aliases:['gold-orbit']},
"hot-orbit": {image:'orbit-hot.png',title:'Hot Orbit', aliases:[]},
"lunar-orbit": {image:'orbit-lunar.png',title:'Lunar Orbit', aliases:[]},
"experience-points": {image:'experience-points.png',title:'Experience Points', aliases:['xp', 'experience']},
"influence-points": {image:'influence-points.png',title:'Influence Points', aliases:['ip', 'influence']},
"in": {image:'in.png',title:'In', aliases:['immigration', 'plus']},
"out": {image:'out.png',title:'Out', aliases:['emigration', 'min']},
"specialised": {image:'specialised.png',title:'Specialised', aliases:['corp']},
"labour": {image:'labour.png',title:'Labour', aliases:['industry']},
"tax": {image:'tax.png',title:'Taxes', aliases:[]},
"turns": {image:'turns.png',title:'Turns', aliases:['turn']},
"sector": {image:'hex-distance.png',title:'Sector', aliases:['hex']},
"population": {image:'population.png',title:'Population', aliases:['pop']},
"power": {image:'power.png',title:'Power', aliases:[]},
"construction-materials": {image:'product-construction-materials.png',title:'Construction Materials (2 Metals)', aliases:['conmats']},
"consumer-goods": {image:'product-consumer-goods.png',title:'Consumer Goods (Metals, Organics)', aliases:['congoods']},
"electronics": {image:'product-electronics.png',title:'Electronics (2 Crystals)', aliases:[]},
"entertainment": {image:'product-entertainment.png',title:'Entertainment (2 Information)', aliases:[]},
"exotic-matter-devices": {image:'product-exotic-matter-devices.png',title:'Exotic Matter Devices (2 Rare Elements)', aliases:['emds']},
"food": {image:'product-food.png',title:'Food (2 Organics)', aliases:[]},
"healthcare-products": {image:'product-healthcare-products.png',title:'Healthcare Products (Organics, Rare Elements)', aliases:['healthcare']},
"ict-technology": {image:'product-ict-technology.png',title:'Ict Technology (Information, Crystals)', aliases:['ict']},
"research": {image:'product-research.png',title:'Research (Rare Elements, Information)', aliases:[]},
"utilities": {image:'product-utilities.png',title:'Utilities (2 Gasses)', aliases:[]},
"vehicles": {image:'product-vehicles.png',title:'Vehicles (Gasses, Metals)', aliases:[]},
"weapons": {image:'product-weapons.png',title:'Weapons (Crystals, Gasses)', aliases:[]},
"crystals": {image:'raw-crystals.png',title:'Crystals', aliases:[]},
"gasses": {image:'raw-gasses.png',title:'Gasses', aliases:['gas']},
"information": {image:'raw-information.png',title:'Information', aliases:[]},
"metals": {image:'raw-metals.png',title:'Metals', aliases:[]},
"organics": {image:'raw-organics.png',title:'Organics', aliases:[]},
"rare-elements": {image:'raw-rare-elements.png',title:'Rare Elements', aliases:['rares']},
"trade-capacity": {image:'trade-capacity.png',title:'Trade Capacity', aliases:['tradecap']},
"fleet-trade": {image:'fleet-trade.png',title:'Fleet Trade Capacity', aliases:['cargo']},
"holonet-trade": {image:'holonet-trade.png',title:'Holonet Trade Capacity', aliases:['holo-trade', 'bandwidth']},
"open-market-trade": {image:'open-market-trade.png',title:'Open Market Trade Capacity', aliases:['om-trade']},
"mass-transit-cargo-freighters": {image:'special-mass-transit-cargo-freighters.png',title:'Mass Transit Cargo Freighters', aliases:['mtcf', 'freighters']},
"holonet-relays": {image:'special-holonet-relays.png',title:'Holonet Relays', aliases:[]},
"hyperspace-nodes": {image:'special-hyperspace-nodes.png',title:'Hyperspace Nodes', aliases:[]},
"terraformation-modules": {image:'special-terraformation-modules.png',title:'Terraformation Modules', aliases:['terraform']},
"capital-ships": {image:'special-capital-ships.png',title:'Capital Ships', aliases:[]},
"superstructure-components": {image:'special-superstructure-components.png',title:'Superstructure Components', aliases:['components']},
"outer-offence": {image:'ring-attack-outer.png',title:'Outer Ring Attack', aliases:['outer-attack']},
"middle-offence": {image:'ring-attack-middle.png',title:'Middle Ring Attack', aliases:['middle-attack']},
"inner-offence": {image:'ring-attack-inner.png',title:'Inner Ring Attack', aliases:['inner-attack']},
"outer-defence": {image:'ring-defence-outer.png',title:'Outer Ring Defence', aliases:[]},
"middle-defence": {image:'ring-defence-middle.png',title:'Middle Ring Defence', aliases:[]},
"inner-defence": {image:'ring-defence-inner.png',title:'Inner Ring Defence', aliases:[]},
"credits": {image:'credit.png',title:'Generic Credits', aliases:['creds']},
"kelwaraan-credits": {image:'credit-kelwaraan.png',title:'Kelwaraan Credits', aliases:['kelwaraans', 'k-creds']},
};

// reference all aliases as icons
for(var i in data) {
	var icon = data[i];
	for(var j in icon.aliases) {
		data[icon.aliases[j]] = icon;
	}
}

/**
 * returns the URL of the base image of the given icon string.
 *
 * @param iconStr the icon string to analyze, same syntax as the wiki plugin
 * @returns the URL of the base image that would be used
 */
var image = function(iconStr) {
	var match = /\+?([a-z-]+)/g;
    var parts = match.exec(iconStr);
    if(!parts) return "";

	var icon = data[parts[1]];
	if(typeof icon == 'undefined') return "";

    return fwurg.url('images/' + icon.image);
};

/**
 * Renders a single icon into HTML.
 *
 * @param iconStr the icon string to render, same syntax as the wiki plugin
 * @returns the HTML to render display the requested icon
 */
var draw = function(iconStr) {
	var match = /\+?([a-z-]+)/g;
	var overlays = [];
	var parts;
	while(parts = match.exec(iconStr)) {
		overlays.push(parts[1]);
	}
	
	var title = '';
	var images = [];
	var base = overlays.shift();
	var icon = data[base];
	if(typeof icon == 'undefined') return "";
	images.push(icon.image);
	title = icon.title;

	for(var k in overlays) {
		var icon = data[overlays[k]];
		if(typeof icon == 'undefined') continue;
		images.push(icon.image);
		title += ", "+icon.title;
	}


	var result = '';
	result += '<span title="' + title + '">';

	var clazz = 'middle ';
	if(images.length == 1) {
		clazz += ' fwurgicon-simple';
	} else {
		clazz += ' fwurgicon-complex';
	}
	for(var i=0; i<images.length; i++) {
		var image = fwurg.url('images/' + images[i]);

		if(i < images.length-1) {
			// somewhere in the list
			result += "<span style='background:url(" + image + ") no-repeat' class='" + clazz + "'>";
		} else {
			// last one in the list
			result += "<img class='" + clazz + "' src='" + image + "' alt='"+iconStr+"'/>";
		}
		// no class for non-first items
		clazz = 'fwurgicon-layer';
	}

	for(var i=0;i<images.length-1;i++) result += '</span>';
	result += '</span>';

	return result;
};

function render(message) {
  return message.replace(/\(:.+?\)/g, draw);
}

// export the draw function
fwurg.icons = {
	draw: draw,
	render: render,
    image: image
};

})(fwurg);
